/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;

public class BorderBackgroundView
extends FrameLayout {
    private View backColorView;

    public BorderBackgroundView(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public BorderBackgroundView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public BorderBackgroundView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(@NonNull Context context, @Nullable AttributeSet attrs) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_view_border_background, (ViewGroup)this, true);
        MaskableFrameLayout maskableFrameLayout = (MaskableFrameLayout)view.findViewById(R.id.chMaskBorderBackground);
        this.backColorView = view.findViewById(R.id.chColorBorderBackground);
        if (attrs != null) {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.BorderBackgroundView, 0, 0);
            try {
                maskableFrameLayout.setMask(typedArray.getDrawable(R.styleable.BorderBackgroundView_ch_bbv_mask));
                this.setColor(typedArray.getColor(R.styleable.BorderBackgroundView_ch_bbv_backColor, 0));
            }
            finally {
                typedArray.recycle();
            }
        }
    }

    public void setColor(int color2) {
        if (this.backColorView != null) {
            this.backColorView.setBackgroundColor(color2);
        }
    }
}

