package com.zoyi.channel.plugin.android.activity.photo_album;

import android.animation.Animator;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.graphics.Color;
import android.view.View;
import android.widget.ImageButton;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.download.DownloadActivity;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.FileMeta;
import com.zoyi.channel.plugin.android.model.etc.FileMetaImpl;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoViewAttacher;
import com.zoyi.channel.plugin.android.view.layout.PhotoViewPager;

import java.util.Collections;

/**
 * Created by mika on 2017. 1. 11..
 */
public class PhotoAlbumActivity extends BaseActivity2
    implements View.OnClickListener, PhotoViewAttacher.OnPhotoTapListener {

  private static final int ANIMATION_DURATION = 200;

  private View layoutOverlay;
  private ImageButton downloadButton;
  private ImageButton copyLinkButton;
  private ImageButton closeButton;

  private boolean menuVisible = true;

  private PhotoViewPager viewPager;
  private PhotoAlbumPagerAdapter adapter;

  @Initializer
  @Override
  protected boolean onCreate() {
    init(R.layout.ch_plugin_activity_photo_album, Color.BLACK, false);

    layoutOverlay = findViewById(R.id.layout_image);
    viewPager = findViewById(R.id.photo_view_pager);
    copyLinkButton = findViewById(R.id.button_link);
    downloadButton = findViewById(R.id.button_download);
    closeButton = findViewById(R.id.button_close_image);

    downloadButton.setOnClickListener(this);
    copyLinkButton.setOnClickListener(this);
    closeButton.setOnClickListener(this);

    FileMetaImpl fileMeta = FileMetaImpl.getInstance(getString(Const.EXTRA_URL), getString(Const.EXTRA_FILE_NAME));

    adapter = new PhotoAlbumPagerAdapter(this, this);

    if (fileMeta != null) {
      adapter.setItems(Collections.singletonList(fileMeta));

      viewPager.setAdapter(adapter);
      viewPager.setCurrentItem(0);
      return true;
    }
    return false;
  }

  @Override
  public void onClick(View view) {
    int id = view.getId();

    if (id == R.id.button_close_image) {
      finish();
    }
    if (id == R.id.button_link) {
      copyLink();
    }
    if (id == R.id.button_download) {
      download();
    }
  }

  private void copyLink() {
    FileMeta fileMeta = adapter.getItem(viewPager.getCurrentItem());
    if (fileMeta != null) {
      try {
        ClipboardManager clipboard = (ClipboardManager) getSystemService(CLIPBOARD_SERVICE);
        ClipData clip = ClipData.newPlainText("text", fileMeta.getUrl());
        clipboard.setPrimaryClip(clip);

        UIUtils.showToast(this, ResUtils.getString(this, "ch.photo.url_copied_to_clipboard"));
      } catch (Exception ex) {
        UIUtils.showToast(this, ResUtils.getString(this, "ch.photo.read_file_info_failed"));
      }
    }
  }

  private void download() {
    FileMeta fileMeta = adapter.getItem(viewPager.getCurrentItem());
    if (fileMeta != null) {
      IntentUtils.setNextActivity(this, DownloadActivity.class)
          .putExtra(Const.EXTRA_URL, fileMeta.getUrl())
          .putExtra(Const.EXTRA_FILE_NAME, fileMeta.getName())
          .putExtra(Const.EXTRA_IMAGE, true)
          .setTransition(Transition.NONE)
          .startActivity();
    }
  }

  @Override
  public void onPhotoTap(View view, float x, float y) {
    animateOverlay();
  }

  @Override
  public void onOutsidePhotoTap() {
    animateOverlay();
  }

  private void animateOverlay() {
    layoutOverlay.animate()
        .alpha(menuVisible ? 0f : 1f)
        .setDuration(ANIMATION_DURATION)
        .setListener(animatorListener).start();
  }

  private Animator.AnimatorListener animatorListener = new Animator.AnimatorListener() {
    @Override
    public void onAnimationStart(Animator animator) {
      menuVisible = !menuVisible;

      if (menuVisible) {
        layoutOverlay.setVisibility(View.VISIBLE);
      }
    }

    @Override
    public void onAnimationEnd(Animator animator) {
      layoutOverlay.setVisibility(menuVisible ? View.VISIBLE : View.GONE);
    }

    @Override
    public void onAnimationCancel(Animator animator) {
    }

    @Override
    public void onAnimationRepeat(Animator animator) {
    }
  };
}
