package com.zoyi.channel.plugin.android.activity.chat.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.global.Const;

public class DummyItem implements MessageItem {

  @NonNull
  private Long primaryKey;

  private String secondaryKey;

  public DummyItem(@NonNull Long primaryKey, String secondaryKey) {
    this.primaryKey = primaryKey;
    this.secondaryKey = secondaryKey;
  }

  @Override
  public MessageType getType() {
    return MessageType.UNKNOWN;
  }

  @NonNull
  @Override
  public Long getPrimaryKey() {
    return primaryKey;
  }

  @Override
  public String getSecondaryKey() {
    return secondaryKey;
  }

  @Nullable
  public static DummyItem createItem(@Nullable String requestId) {
    if (requestId == null) {
      return null;
    }

    try {
      // millisecond timestamp is 13 digit until 2286/11/20
      return new DummyItem(Long.valueOf(requestId.substring(0, 13)) * Const.SENDING_MESSAGE_PRIMARY_KEY_MULTIPLER, requestId);
    } catch (Exception ex) {
    }
    return null;
  }

  @NonNull
  public static DummyItem createSendFileItem() {
    return new DummyItem(Const.SENDING_FILE_PRIMARY_KEY, "");
  }
}
