/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.common.navigation;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.selector.BootDataSelector;
import com.zoyi.channel.plugin.android.store.binder.Binder;
import com.zoyi.channel.plugin.android.util.ComponentUtils;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.button.ThemeEffectiveView;
import com.zoyi.channel.plugin.android.view.textview.CHTextView;
import com.zoyi.rx.functions.Action3;

public class ChannelInfoNavigationView
extends LinearLayout
implements ThemeEffectiveView {
    private CHTextView textChannelName;
    private CHTextView textDescription;
    private ImageView imageChannelStatus;
    @Nullable
    private Binder dataBinder;

    public ChannelInfoNavigationView(Context context) {
        super(context);
        this.init(context, null);
    }

    public ChannelInfoNavigationView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ChannelInfoNavigationView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @Initializer
    private void init(Context context, @Nullable AttributeSet attrs) {
        View root = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_navigation_channel_info, (ViewGroup)this, true);
        this.textChannelName = (CHTextView)root.findViewById(R.id.textNavigationChannelName);
        this.textDescription = (CHTextView)root.findViewById(R.id.textNavigationDescription);
        this.imageChannelStatus = (ImageView)root.findViewById(R.id.imageNavigationChannelStatus);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.dataBinder = BootDataSelector.bindBootData((Action3<Plugin, Channel, Integer>)((Action3)(plugin, channel, isWorking) -> {
            this.textChannelName.setText(channel.getName());
            this.textDescription.setText(ComponentUtils.getShortResponseDescription(channel, isWorking));
            this.imageChannelStatus.setImageResource(ComponentUtils.getResponseSymbol(plugin, channel, isWorking == 0));
        }));
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.dataBinder != null) {
            this.dataBinder.unbind();
        }
    }

    @Override
    public void onThemeChange(int backColor, int textColor) {
        this.textChannelName.setTextColor(textColor);
        this.textDescription.setTextColor(textColor);
    }
}

