/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.com.bumptech.glide.load.resource.bitmap;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.Gravity;
import com.zoyi.com.bumptech.glide.load.resource.drawable.GlideDrawable;

public class GlideBitmapDrawable
extends GlideDrawable {
    private final Rect destRect = new Rect();
    private int width;
    private int height;
    private boolean applyGravity;
    private boolean mutated;
    private BitmapState state;

    public GlideBitmapDrawable(Resources res, Bitmap bitmap) {
        this(res, new BitmapState(bitmap));
    }

    GlideBitmapDrawable(Resources res, BitmapState state) {
        int targetDensity;
        if (state == null) {
            throw new NullPointerException("BitmapState must not be null");
        }
        this.state = state;
        if (res != null) {
            int density = res.getDisplayMetrics().densityDpi;
            state.targetDensity = targetDensity = density == 0 ? 160 : density;
        } else {
            targetDensity = state.targetDensity;
        }
        this.width = state.bitmap.getScaledWidth(targetDensity);
        this.height = state.bitmap.getScaledHeight(targetDensity);
    }

    public int getIntrinsicWidth() {
        return this.width;
    }

    public int getIntrinsicHeight() {
        return this.height;
    }

    @Override
    public boolean isAnimated() {
        return false;
    }

    @Override
    public void setLoopCount(int loopCount) {
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean isRunning() {
        return false;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.applyGravity = true;
    }

    public Drawable.ConstantState getConstantState() {
        return this.state;
    }

    public void draw(Canvas canvas) {
        if (this.applyGravity) {
            Gravity.apply((int)119, (int)this.width, (int)this.height, (Rect)this.getBounds(), (Rect)this.destRect);
            this.applyGravity = false;
        }
        canvas.drawBitmap(this.state.bitmap, null, this.destRect, this.state.paint);
    }

    public void setAlpha(int alpha) {
        int currentAlpha = this.state.paint.getAlpha();
        if (currentAlpha != alpha) {
            this.state.setAlpha(alpha);
            this.invalidateSelf();
        }
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.state.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        Bitmap bm = this.state.bitmap;
        return bm == null || bm.hasAlpha() || this.state.paint.getAlpha() < 255 ? -3 : -1;
    }

    public Drawable mutate() {
        if (!this.mutated && super.mutate() == this) {
            this.state = new BitmapState(this.state);
            this.mutated = true;
        }
        return this;
    }

    public Bitmap getBitmap() {
        return this.state.bitmap;
    }

    static class BitmapState
    extends Drawable.ConstantState {
        private static final int DEFAULT_PAINT_FLAGS = 6;
        private static final Paint DEFAULT_PAINT = new Paint(6);
        private static final int GRAVITY = 119;
        final Bitmap bitmap;
        int targetDensity;
        Paint paint = DEFAULT_PAINT;

        public BitmapState(Bitmap bitmap) {
            this.bitmap = bitmap;
        }

        BitmapState(BitmapState other) {
            this(other.bitmap);
            this.targetDensity = other.targetDensity;
        }

        void setColorFilter(ColorFilter colorFilter) {
            this.mutatePaint();
            this.paint.setColorFilter(colorFilter);
        }

        void setAlpha(int alpha) {
            this.mutatePaint();
            this.paint.setAlpha(alpha);
        }

        void mutatePaint() {
            if (DEFAULT_PAINT == this.paint) {
                this.paint = new Paint(6);
            }
        }

        public Drawable newDrawable() {
            return new GlideBitmapDrawable(null, this);
        }

        public Drawable newDrawable(Resources res) {
            return new GlideBitmapDrawable(res, this);
        }

        public int getChangingConfigurations() {
            return 0;
        }
    }
}

