/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.app.Application;
import android.content.Context;
import android.os.Looper;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.ActivityLifecycleManager;
import com.zoyi.channel.plugin.android.ChannelActionHandler;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelPluginCompletionStatus;
import com.zoyi.channel.plugin.android.ChannelPluginListener;
import com.zoyi.channel.plugin.android.ChannelPluginSettings;
import com.zoyi.channel.plugin.android.OnBootListener;
import com.zoyi.channel.plugin.android.Profile;
import com.zoyi.channel.plugin.android.User;
import com.zoyi.channel.plugin.android.action.BootAction;
import com.zoyi.channel.plugin.android.action.ChatAction;
import com.zoyi.channel.plugin.android.action.EventAction;
import com.zoyi.channel.plugin.android.activity.chat.manager.ChatManager;
import com.zoyi.channel.plugin.android.activity.common.chat.ChatContentType;
import com.zoyi.channel.plugin.android.activity.lounge.LoungeActivity;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.push.ChannelPushManager;
import com.zoyi.channel.plugin.android.selector.GlobalSelector;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.store.GlobalStore;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.channel.plugin.android.store.TimerStore;
import com.zoyi.channel.plugin.android.store.base.Store;
import com.zoyi.channel.plugin.android.util.BootManager;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.com.annimon.stream.Optional;
import java.util.concurrent.RejectedExecutionException;

class RealChannelIO {
    private Application application;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private ChannelActionHandler handler;
    private ActivityLifecycleManager activityLifecycleManager;

    RealChannelIO(Application application) {
        this.application = application;
        this.uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        this.handler = new ChannelActionHandler();
        this.activityLifecycleManager = new ActivityLifecycleManager();
        SocketManager.create(application);
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityLifecycleManager);
        Thread.setDefaultUncaughtExceptionHandler((thread, ex) -> {
            if (this.uncaughtExceptionHandler != null) {
                this.uncaughtExceptionHandler.uncaughtException(thread, ex);
            }
            if (!SocketManager.isReady() && Looper.getMainLooper().getThread() != thread && ex instanceof RejectedExecutionException) {
                SocketManager.reconnect();
            }
        });
    }

    Application getApplication() {
        return this.application;
    }

    void boot(final @Nullable ChannelPluginSettings pluginSettings, @Nullable Profile profile, final @Nullable OnBootListener listener) {
        this.shutdown();
        BootAction.boot(pluginSettings, profile, listener, new RestSubscriber<PluginWrapper>(){

            @Override
            public void onError(RetrofitException e) {
                BootManager.sendNetworkError(listener, e);
            }

            @Override
            public void onNext(PluginWrapper repo) {
                repo.set();
                RealChannelIO.this.onBoot(pluginSettings, repo.getChannel(), repo.getPlugin(), repo.getUser(), listener);
                Optional.ofNullable((Object)repo).map(PluginWrapper::getUser).map(com.zoyi.channel.plugin.android.model.rest.User::getPopUpChatId).ifPresent(chatId -> ChatAction.fetchPopUpChat(repo.getUser().getPopUpChatId()));
            }
        });
    }

    private void onBoot(ChannelPluginSettings pluginSettings, Channel channel, Plugin plugin, com.zoyi.channel.plugin.android.model.rest.User user, @Nullable OnBootListener listener) {
        PrefSupervisor.setLatestBootData((Context)this.application, pluginSettings.getPluginKey(), channel.getId(), user.getId());
        SettingsStore.get().locale.set(user.getUserLocale());
        SettingsStore.get().launcherConfig.set(pluginSettings.getLauncherConfig());
        SettingsStore.get().hideDefaultInAppPush.set(pluginSettings.isHideDefaultInAppPush());
        SettingsStore.get().enabledTrackDefaultEvent.set(pluginSettings.isEnabledTrackDefaultEvent());
        ChannelIO.setDebugMode(pluginSettings.isDebugMode());
        SettingsStore.get().showTranslation.set(PrefSupervisor.canTranslateMessage((Context)this.application));
        SettingsStore.get().showClosedChat.set(PrefSupervisor.isShownClosedChat((Context)this.application));
        SettingsStore.get().raiseSoundVibrate.set(PrefSupervisor.isEnabledPushAlarm((Context)this.application));
        ChatManager.initialize();
        if (GlobalStore.get().jwt.get() == null) {
            GlobalStore.get().jwt.set(PrefSupervisor.getJwt((Context)this.application));
        }
        ChannelPushManager.sendTokenToChannelIO((Context)this.application);
        SocketManager.setChannelId(channel.getId());
        if (GlobalStore.get().topActivity.get() != null) {
            SocketManager.connect();
        }
        if (SettingsStore.get().showLauncher.get().booleanValue() && SettingsStore.get().enabledTrackDefaultEvent.get().booleanValue()) {
            EventAction.trackPageView();
        }
        this.handler.handle();
        this.activityLifecycleManager.attachTimestampTimer();
        TimerStore.get().now.set(TimeUtils.getCurrentTime());
        GlobalStore.get().bootState.set(true);
        if (listener != null) {
            listener.onCompletion(ChannelPluginCompletionStatus.SUCCESS, User.newInstance(user));
        }
        PrefSupervisor.clearLatestPushData((Context)this.application);
    }

    void shutdown() {
        GlobalStore.get().bootState.set(false);
        this.handler.unHandle();
        this.activityLifecycleManager.detachTimestampTimer();
        SocketManager.setChannelId(null);
        SocketManager.disconnect();
        Action.invoke(ActionType.SHUTDOWN);
        Action.release();
        ChatManager.release();
        String jwt = GlobalStore.get().jwt.get();
        ChannelPushManager.deleteToken((Context)this.application, jwt);
        Store.destroy();
        PrefSupervisor.clearLatestBootData((Context)this.application);
        PrefSupervisor.setJwt((Context)this.application, null);
    }

    public boolean startMessenger(@Nullable Context context, @Nullable String chatId, boolean isAnimated) {
        if (!ChannelIO.isInitializedChannelIO()) {
            L.e("Fail to start messenger, please initialize ChannelIO first");
            return false;
        }
        if (!GlobalStore.get().bootState.get().booleanValue()) {
            L.e("Fail to start messenger, please 'Boot' first");
            return false;
        }
        if (context == null) {
            L.e("Fail to start messenger, context can't be NULL");
            return false;
        }
        IntentUtils.setNextActivity(context, LoungeActivity.class).putExtra("chatContentType", ChatContentType.USER_CHAT.toString()).putExtra("chatContentId", chatId).putExtra("animated", isAnimated).putExtra("topActivityName", GlobalSelector.getTopActivityName()).setFlag(0x4000000).setTransition(isAnimated ? Transition.SLIDE_FROM_BOTTOM : Transition.NONE).startActivity();
        return true;
    }

    void setListener(@Nullable ChannelPluginListener listener) {
        this.handler.setListener(listener);
    }

    void clearListener() {
        this.handler.clearListener();
    }

    @Nullable
    ChannelPluginListener getListener() {
        return this.handler.getListener();
    }
}

