/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.video_player;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.view.video_player.AbsVideoPlayerView;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.com.google.android.exoplayer2.DefaultRenderersFactory;
import com.zoyi.com.google.android.exoplayer2.ExoPlayerFactory;
import com.zoyi.com.google.android.exoplayer2.Player;
import com.zoyi.com.google.android.exoplayer2.RenderersFactory;
import com.zoyi.com.google.android.exoplayer2.SimpleExoPlayer;
import com.zoyi.com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.zoyi.com.google.android.exoplayer2.source.MediaSource;
import com.zoyi.com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.zoyi.com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.zoyi.com.google.android.exoplayer2.trackselection.TrackSelection;
import com.zoyi.com.google.android.exoplayer2.trackselection.TrackSelector;
import com.zoyi.com.google.android.exoplayer2.ui.PlayerView;
import com.zoyi.com.google.android.exoplayer2.upstream.DataSource;
import com.zoyi.com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.zoyi.com.google.android.exoplayer2.util.Util;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;

public abstract class AbsPopUpVideoPlayerView
extends AbsVideoPlayerView {
    private Context context;
    protected PlayerView playerAttachment;
    @Nullable
    protected SimpleExoPlayer exoPlayer;
    @Nullable
    private Subscription videoProgressSubscription;

    public AbsPopUpVideoPlayerView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public AbsPopUpVideoPlayerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public AbsPopUpVideoPlayerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        LayoutInflater.from((Context)context).inflate(this.getLayoutId(), (ViewGroup)this);
        this.playerAttachment = (PlayerView)this.findViewById(R.id.ch_playerAttachment);
    }

    public AbsPopUpVideoPlayerView setUrl(@Nullable String messageId, File attachment) {
        this.setId(String.format("%s:%s", messageId, attachment.getId()));
        AdaptiveTrackSelection.Factory videoTrackSelectionFactory = new AdaptiveTrackSelection.Factory();
        DefaultTrackSelector trackSelector = new DefaultTrackSelector((TrackSelection.Factory)videoTrackSelectionFactory);
        this.exoPlayer = ExoPlayerFactory.newSimpleInstance((Context)this.context, (RenderersFactory)new DefaultRenderersFactory(this.context), (TrackSelector)trackSelector);
        this.exoPlayer.addListener(new Player.EventListener(){

            public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
                AbsPopUpVideoPlayerView.this.changeVideoState(playWhenReady);
                if (playWhenReady) {
                    AbsPopUpVideoPlayerView.this.bindVideoProgress();
                } else {
                    AbsPopUpVideoPlayerView.this.unbindVideoProgress();
                }
                switch (playbackState) {
                    case 4: {
                        if (AbsPopUpVideoPlayerView.this.exoPlayer == null) break;
                        AbsPopUpVideoPlayerView.this.exoPlayer.seekTo(0L);
                        AbsPopUpVideoPlayerView.this.exoPlayer.setPlayWhenReady(false);
                    }
                }
            }
        });
        this.playerAttachment.setPlayer((Player)this.exoPlayer);
        this.playerAttachment.setResizeMode(4);
        DefaultDataSourceFactory dataSourceFactory = new DefaultDataSourceFactory(this.context, Util.getUserAgent((Context)this.context, (String)"ChannelSDK"));
        ExtractorMediaSource videoSource = new ExtractorMediaSource.Factory((DataSource.Factory)dataSourceFactory).createMediaSource(Uri.parse((String)attachment.getUrl()));
        this.exoPlayer.prepare((MediaSource)videoSource);
        this.exoPlayer.setPlayWhenReady(true);
        this.exoPlayer.seekTo(this.getLatestSeconds() * TimeUnit.SECONDS.toMillis(1L));
        if (this.exoPlayer != null) {
            this.exoPlayer.setVolume(0.0f);
        }
        return this;
    }

    public void setOnClickListener(@Nullable View.OnClickListener l) {
        this.playerAttachment.setOnClickListener(l);
    }

    @Override
    void onVideoPaused() {
        if (this.exoPlayer != null) {
            this.exoPlayer.setPlayWhenReady(false);
        }
    }

    private void bindVideoProgress() {
        if (this.videoProgressSubscription == null || this.videoProgressSubscription.isUnsubscribed()) {
            this.unbindVideoProgress();
            this.videoProgressSubscription = Observable.interval((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS).onBackpressureLatest().subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> Optional.ofNullable((Object)this.exoPlayer).map(SimpleExoPlayer::getCurrentPosition).map(position -> position / TimeUnit.SECONDS.toMillis(1L)).ifPresent(this::changeVideoPosition));
        }
    }

    private void unbindVideoProgress() {
        this.dispose(this.videoProgressSubscription);
    }

    protected void dispose(@Nullable Subscription subscription) {
        if (subscription != null && !subscription.isUnsubscribed()) {
            subscription.unsubscribe();
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.dispose(this.videoProgressSubscription);
        this.videoProgressSubscription = null;
        if (this.exoPlayer != null) {
            this.exoPlayer.release();
            this.exoPlayer = null;
        }
    }

    protected abstract int getLayoutId();
}

