package com.zoyi.channel.plugin.android.view.video_player;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.view.youtube.player.PlayerConstants;
import com.zoyi.channel.plugin.android.view.youtube.player.YouTubePlayer;
import com.zoyi.channel.plugin.android.view.youtube.player.listener.AbstractYouTubePlayerListener;
import com.zoyi.channel.plugin.android.view.youtube.player.views.CHYouTubePlayerView;

public class YouTubeVideoPlayerView extends AbsVideoPlayerView {

  public YouTubeVideoPlayerView(@NonNull Context context) {
    super(context);

    init(context);
  }

  public YouTubeVideoPlayerView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);

    init(context);
  }

  public YouTubeVideoPlayerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);

    init(context);
  }

  @Nullable
  private CHYouTubePlayerView playerYouTube;

  @Nullable
  private YouTubePlayer youTubePlayer;

  private void init(Context context) {
    LayoutInflater.from(context).inflate(R.layout.ch_view_youtube_video_player, this);

    playerYouTube = findViewById(R.id.chPlayerYouTube);
  }

  public void setVideoId(@Nullable String messageId, @Nullable String webPageId, String videoId) {
    setId(String.format("%s:%s:%s", messageId, webPageId, videoId));

    if (playerYouTube != null) {
      playerYouTube.getYouTubePlayerWhenReady(youTubePlayer -> {
        this.youTubePlayer = youTubePlayer;

        youTubePlayer.mute();
        youTubePlayer.loadVideo(videoId, getLatestSeconds());
      });

      playerYouTube.addYouTubePlayerListener(new AbstractYouTubePlayerListener() {
        @Override
        public void onStateChange(YouTubePlayer youTubePlayer, PlayerConstants.PlayerState state) {
          changeVideoState(state == PlayerConstants.PlayerState.PLAYING || state == PlayerConstants.PlayerState.BUFFERING);
        }

        @Override
        public void onCurrentSecond(YouTubePlayer youTubePlayer, float second) {
          try {
            changeVideoPosition((long) second);
          } catch (Exception ex) {
          }
        }
      });
    }
  }

  @Override
  void onVideoPaused() {
    if (youTubePlayer != null) {
      youTubePlayer.pause();
    }
  }

  @Override
  public void clear() {
    super.clear();

    if (playerYouTube != null) {
      playerYouTube.release();
    }
  }
}
