package com.zoyi.channel.plugin.android.view.video_player;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.Views;

public class FullScreenPopUpYouTubeVideoPlayerView extends AbsPopUpYouTubeVideoPlayerView {

  public FullScreenPopUpYouTubeVideoPlayerView(@NonNull Context context) {
    super(context);

    init();
  }

  public FullScreenPopUpYouTubeVideoPlayerView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);

    init();
  }

  public FullScreenPopUpYouTubeVideoPlayerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);

    init();
  }

  private View buttonVideoVolumeOn;
  private View buttonVideoVolumeOff;

  private void init() {
    buttonVideoVolumeOn = findViewById(R.id.ch_buttonVideoVolumeOn);
    buttonVideoVolumeOff = findViewById(R.id.ch_buttonVideoVolumeOff);

    buttonVideoVolumeOn.setOnClickListener(v -> applyVolumeButton(false));
    buttonVideoVolumeOff.setOnClickListener(v -> applyVolumeButton(true));

    applyVolumeButton(false);
  }

  private void applyVolumeButton(boolean isVolumeOn) {
    if (youTubePlayer != null) {
      if (isVolumeOn) {
        youTubePlayer.unMute();
      } else {
        youTubePlayer.mute();
      }
    }

    Views.setVisibility(buttonVideoVolumeOn, isVolumeOn);
    Views.setVisibility(buttonVideoVolumeOff, !isVolumeOn);

    changeVideoVolumeState(isVolumeOn);
  }

  @Override
  protected int getLayoutId() {
    return R.layout.ch_view_popup_fullscreen_youtube_video_player;
  }
}
