package com.zoyi.channel.plugin.android.view.video_player;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ProgressBar;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.view.youtube.player.PlayerConstants;
import com.zoyi.channel.plugin.android.view.youtube.player.YouTubePlayer;
import com.zoyi.channel.plugin.android.view.youtube.player.listener.AbstractYouTubePlayerListener;
import com.zoyi.channel.plugin.android.view.youtube.player.views.CHYouTubePlayerView;

public abstract class AbsPopUpYouTubeVideoPlayerView extends AbsVideoPlayerView {

  public AbsPopUpYouTubeVideoPlayerView(@NonNull Context context) {
    super(context);

    init(context);
  }

  public AbsPopUpYouTubeVideoPlayerView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);

    init(context);
  }

  public AbsPopUpYouTubeVideoPlayerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);

    init(context);
  }

  @Nullable
  private CHYouTubePlayerView playerYouTube;

  @Nullable
  protected YouTubePlayer youTubePlayer;

  private ProgressBar progressBar;

  private View viewClickCover;

  private void init(Context context) {
    LayoutInflater.from(context).inflate(getLayoutId(), this);

    playerYouTube = findViewById(R.id.chPlayerYouTube);
    progressBar = findViewById(R.id.ch_progress);
    viewClickCover = findViewById(R.id.ch_viewClickCover);
  }

  public void setVideoId(
      @Nullable String messageId,
      @Nullable String webPageId,
      String videoId,
      @Nullable OnClickListener listener
  ) {
    super.setId(String.format("%s:%s:%s", messageId, webPageId, videoId));

    if (listener != null) {
      viewClickCover.setOnClickListener(listener);
    }

    if (playerYouTube != null) {

      playerYouTube.getPlayerUiController().showUi(false);

      playerYouTube.getYouTubePlayerWhenReady(youTubePlayer -> {
        this.youTubePlayer = youTubePlayer;

        youTubePlayer.mute();
        youTubePlayer.loadVideo(videoId, getLatestSeconds());
      });

      playerYouTube.addYouTubePlayerListener(new AbstractYouTubePlayerListener() {
        @Override
        public void onStateChange(YouTubePlayer youTubePlayer, PlayerConstants.PlayerState state) {
          changeVideoState(state == PlayerConstants.PlayerState.PLAYING || state == PlayerConstants.PlayerState.BUFFERING);
        }

        @Override
        public void onCurrentSecond(YouTubePlayer youTubePlayer, float second) {
          try {
            progressBar.setProgress((int) second);
            changeVideoPosition((long) second);
          } catch (Exception ex) {
          }
        }

        @Override
        public void onVideoDuration(YouTubePlayer youTubePlayer, float duration) {
          progressBar.setMax((int) duration);
        }
      });

    }
  }

  @Override
  void onVideoPaused() {
    if (youTubePlayer != null) {
      youTubePlayer.pause();
    }
  }

  @Override
  public void clear() {
    super.clear();

    if (playerYouTube != null) {
      playerYouTube.release();
    }
  }

  protected abstract int getLayoutId();
}
