package com.zoyi.channel.plugin.android.view.media_thumbnail;

import android.content.Context;
import android.graphics.Point;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;

import com.zoyi.channel.plugin.android.activity.chat.listener.OnAttachmentContentActionListener;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.util.CalculationUtils;
import com.zoyi.channel.plugin.android.util.draw.Display;

public class SquareAttachmentMediaThumbnailView extends AttachmentMediaThumbnailView {

  private Context context;

  public SquareAttachmentMediaThumbnailView(@NonNull Context context) {
    super(context);

    init(context);
  }

  public SquareAttachmentMediaThumbnailView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);

    init(context);
  }

  public SquareAttachmentMediaThumbnailView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);

    init(context);
  }

  private void init(Context context) {
    this.context = context;
  }

  @Override
  public void setAttachment(@Nullable String messageId, File attachment, @Nullable OnAttachmentContentActionListener listener) {
    super.setAttachment(messageId, attachment, listener);

    int screenWidth = Display.getWidth(context);
    int imageWidth = Math.max(attachment.getWidth(), 1);
    int imageHeight = Math.max(attachment.getHeight(), 1);
    int size = CalculationUtils.min(screenWidth / 2, imageWidth, imageHeight);

    setImage(attachment.getThumbnailURL(new Point(size, size)));
  }
}
