package com.zoyi.channel.plugin.android.util;

import android.graphics.Color;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.util.Pair;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;

public class ComponentUtils {

  @Nullable
  public static String getResponseKey(@Nullable Channel channel, Boolean isWorking) {
    if (channel == null || channel.getExpectedResponseDelay() == null || isWorking == null) {
      return null;
    }

    if (!isWorking) {
      return "ch.chat.expect_response_delay.out_of_working";
    }

    switch (channel.getExpectedResponseDelay()) {
      case Channel.EXPECTED_RESPONSE_DELAY_INSTANT:
        return "ch.chat.expect_response_delay.instant";

      case Channel.EXPECTED_RESPONSE_DELAY_NORMAL:
        return "ch.chat.expect_response_delay.normal";

      case Channel.EXPECTED_RESPONSE_DELAY_DELAYED:
        return "ch.chat.expect_response_delay.delayed";

      default:
        return null;
    }
  }

  @Nullable
  public static String getShortResponseDescription(@Nullable Channel channel, @Nullable Integer remainMinutes) {
    if (channel == null || channel.getExpectedResponseDelay() == null || remainMinutes == null) {
      return null;
    }

    if (remainMinutes > 0) {
      if (remainMinutes >= 60) {
        return String.format(ResUtils.getString("ch.navigation.next_operation.hour_left"), remainMinutes / 60);
      }
      return String.format(ResUtils.getString("ch.navigation.next_operation.minutes_left"), remainMinutes);
    }
    if (remainMinutes < 0) {
      return ResUtils.getString("ch.chat.expect_response_delay.out_of_working.short_description");
    }

    switch (channel.getExpectedResponseDelay()) {
      case Channel.EXPECTED_RESPONSE_DELAY_INSTANT:
        return ResUtils.getString("ch.chat.expect_response_delay.instant.short_description");

      case Channel.EXPECTED_RESPONSE_DELAY_NORMAL:
        return ResUtils.getString("ch.chat.expect_response_delay.normal.short_description");

      case Channel.EXPECTED_RESPONSE_DELAY_DELAYED:
        return ResUtils.getString("ch.chat.expect_response_delay.delayed.short_description");

      default:
        return null;
    }
  }

  @DrawableRes
  public static int getResponseSymbol(@Nullable Plugin plugin, @Nullable Channel channel, Boolean isWorking) {
    if (plugin == null || channel == null || isWorking == null) {
      return 0;
    }

    int textColor = plugin.getTextColor();

    if (!isWorking) {
      return textColor == Color.WHITE
          ? R.drawable.ch_plugin_offhours_w
          : R.drawable.ch_plugin_offhours_b;
    }

    if (channel.getExpectedResponseDelay() == null) {
      return 0;
    }

    switch (channel.getExpectedResponseDelay()) {
      case Channel.EXPECTED_RESPONSE_DELAY_INSTANT:
        return textColor == Color.WHITE
            ? R.drawable.ch_plugin_fast_w
            : R.drawable.ch_plugin_fast_b;

      case Channel.EXPECTED_RESPONSE_DELAY_NORMAL:
        return textColor == Color.WHITE
            ? R.drawable.ch_plugin_normal_w
            : R.drawable.ch_plugin_normal_b;

      case Channel.EXPECTED_RESPONSE_DELAY_DELAYED:
        return textColor == Color.WHITE
            ? R.drawable.ch_plugin_delayed_w
            : R.drawable.ch_plugin_delayed_b;

      default:
        return 0;
    }
  }
}
