package com.zoyi.channel.plugin.android.store.binder;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.store.state.BaseState;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Action5;

public class Binder5<E, F, G, H, I> extends Binder {

  private BaseState<E> state1;
  private BaseState<F> state2;
  private BaseState<G> state3;
  private BaseState<H> state4;
  private BaseState<I> state5;

  @Nullable
  private Subscription subscription1;
  @Nullable
  private Subscription subscription2;
  @Nullable
  private Subscription subscription3;
  @Nullable
  private Subscription subscription4;
  @Nullable
  private Subscription subscription5;

  public Binder5(BaseState<E> state1, BaseState<F> state2, BaseState<G> state3, BaseState<H> state4, BaseState<I> state5) {
    this.state1 = state1;
    this.state2 = state2;
    this.state3 = state3;
    this.state4 = state4;
    this.state5 = state5;
  }

  public Binder5 bind(Action5<E, F, G, H, I> action5) {
    this.subscription1 = this.state1.attach(e -> action5.call(e, state2.get(), state3.get(), state4.get(), state5.get()));
    this.subscription2 = this.state2.attach(f -> action5.call(state1.get(), f, state3.get(), state4.get(), state5.get()));
    this.subscription3 = this.state3.attach(g -> action5.call(state1.get(), state2.get(), g, state4.get(), state5.get()));
    this.subscription4 = this.state4.attach(h -> action5.call(state1.get(), state2.get(), state3.get(), h, state5.get()));
    this.subscription5 = this.state5.attach(i -> action5.call(state1.get(), state2.get(), state3.get(), state4.get(), i));

    action5.call(state1.get(), state2.get(), state3.get(), state4.get(), state5.get());

    return this;
  }

  @Override
  public void unbind() {
    if (subscription1 != null && !subscription1.isUnsubscribed()) {
      subscription1.unsubscribe();
    }
    if (subscription2 != null && !subscription2.isUnsubscribed()) {
      subscription2.unsubscribe();
    }
    if (subscription3 != null && !subscription3.isUnsubscribed()) {
      subscription3.unsubscribe();
    }
    if (subscription4 != null && !subscription4.isUnsubscribed()) {
      subscription4.unsubscribe();
    }
    if (subscription5 != null && !subscription5.isUnsubscribed()) {
      subscription5.unsubscribe();
    }
    subscription1 = null;
    subscription2 = null;
    subscription3 = null;
    subscription4 = null;
    subscription5 = null;
  }
}
