package com.zoyi.channel.plugin.android.model.rest;

import android.graphics.Point;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.entity.FileMeta;
import com.zoyi.channel.plugin.android.model.entity.Previewable;
import com.zoyi.channel.plugin.android.util.UriUtils;
import com.zoyi.channel.plugin.android.util.io.FilenameUtils;

import java.util.Locale;

/**
 * Created by mika on 2016. 1. 22..
 */
public class File implements Entity, FileMeta, Previewable {

  private static final int TYPE_VIDEO = 0;
  private static final int TYPE_IMAGE = 1;
  private static final int TYPE_OTHER = 2;

  private String id;
  @Nullable
  private String type;
  @Nullable
  private String name;
  @Nullable
  private Long size;
  @Nullable
  private String contentType;
  @Nullable
  private Integer width;
  @Nullable
  private Integer height;
  @Nullable
  private String bucket;
  @Nullable
  private String key;
  @Nullable
  private Boolean thumb;

  @Nullable
  private String previewKey;

  private Double duration;

  @NonNull
  public String getType() {
    if (type == null) {
      return "";
    }
    return type;
  }

  public String getId() {
    return id;
  }

  @Nullable
  public String getName() {
    return name;
  }

  public long getSize() {
    if (size == null) {
      return 0L;
    }
    return size;
  }

  @NonNull
  @Override
  public Integer getWidth() {
    if (width == null) {
      return 0;
    }
    return width;
  }

  @NonNull
  @Override
  public Integer getHeight() {
    if (height == null) {
      return 0;
    }
    return height;
  }

  private String getBucketCdn() {
    return UriUtils.getCloudFrontUrl(bucket);
  }

  @Nullable
  public String getKey() {
    return key;
  }

  public boolean isThumb() {
    if (thumb == null) {
      return true;
    }

    return thumb;
  }

  @Nullable
  public String getPreviewKey() {
    if (previewKey == null) {
      return key;
    }
    return previewKey;
  }

  public double getDuration() {
    if (duration == null) {
      return 0D;
    }
    return duration;
  }

  @Override
  public String getUrl() {
    return String.format("%s/%s", getBucketCdn(), key);
  }

  @Nullable
  public String getThumbnailURL(Point previewImageSize) {
    if (isThumb()) {
      return String.format(
          Locale.US,
          Const.FORMAT_THUMB_URL,
          getBucketCdn(),
          previewImageSize.x,
          previewImageSize.y,
          getPreviewKey()
      );
    } else {
      return getUrl();
    }
  }

  @Nullable
  public String getExtension() {
    return FilenameUtils.getExtension(getName());
  }

  public boolean isImage() {
    return Const.FILE_TYPE_IMAGE.equals(getType());
  }

  public boolean isVideo() {
    return Const.FILE_TYPE_VIDEO.equals(getType());
  }

  public boolean isPreviewable() {
    return isImage() || isVideo();
  }

  public final static String CLASSNAME = "file";
}
