package com.zoyi.channel.plugin.android.model.etc;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Message;

/**
 * Created by jerry on 2018. 2. 22..
 */

public class PushEvent {

  @Nullable
  private String chatId;
  @Nullable
  private String senderAvatarUrl;
  @Nullable
  private String senderName;
  @Nullable
  private String message;

  public PushEvent(Message message, ProfileEntity profile) {
    this.senderName = profile.getName();
    this.senderAvatarUrl = profile.getAvatarUrl();
    this.chatId = message.getChatId();
    this.message = message.getPlainText();
  }

  @Nullable
  public String getChatId() {
    return chatId;
  }

  @Nullable
  public String getSenderAvatarUrl() {
    return senderAvatarUrl;
  }

  @Nullable
  public String getMessage() {
    return message;
  }

  @Nullable
  public String getSenderName() {
    return senderName;
  }
}
