package com.zoyi.channel.plugin.android.activity.settings;

import com.zoyi.channel.plugin.android.action.ProfileBotSchemaAction;
import com.zoyi.channel.plugin.android.activity.settings.contract.SettingsContract;
import com.zoyi.channel.plugin.android.base.AbstractPresenter;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.selector.*;
import com.zoyi.channel.plugin.android.store.PluginStore;

public class SettingsPresenter extends AbstractPresenter<SettingsContract.View> implements SettingsContract.Presenter {

  public SettingsPresenter(SettingsContract.View view) {
    super(view);
  }

  @Override
  public void init() {
    bind(SettingsSelector.bindLocale(locale -> view.onLocaleChange(locale)));

    bind(ProfileBotSelector.bindProfileSchemasFetchState(fetchState -> view.onProfileBotSchemasFetchStateChange(fetchState)));

    bind(ProfileBotSelector.bindProfileSchemas((profileBotSchemas, user) -> view.onProfileBotSchemasChange(profileBotSchemas, user)));

    bind(UserSelector.bindUnsubscribed(unsubscribed -> view.onUnsubscribedChanged(unsubscribed)));

    fetchProfileBotSchema();
  }

  @Override
  public void fetchProfileBotSchema() {
    Plugin plugin = PluginStore.get().pluginState.get();

    if (plugin != null) {
      ProfileBotSchemaAction.getProfileBotSchemaAction(plugin.getId());
    }
  }
}
