package com.zoyi.channel.plugin.android.activity.common.userchat.viewholder;

import android.support.annotation.ColorRes;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.*;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.common.userchat.listener.OnChatClickListener;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.ChatItem;
import com.zoyi.channel.plugin.android.util.*;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.channel.plugin.android.view.textview.CHTextView;
import com.zoyi.channel.plugin.android.view.textview.FileRowTextView;

public class ChatHolder extends RecyclerView.ViewHolder implements View.OnClickListener, View.OnLongClickListener {

  @Nullable
  private OnChatClickListener listener;

  @Nullable
  private ChatItem chatItem;

  private AvatarLayout avatar;
  private CHTextView textName;
  private CHTextView textMessage;
  private FileRowTextView viewFileRow;
  private CHTextView textTime;
  private CHTextView textBadge;

  @Initializer
  public ChatHolder(View itemView, @Nullable OnChatClickListener listener) {
    super(itemView);

    this.listener = listener;

    avatar = itemView.findViewById(R.id.avatar_single);
    avatar.setTextSize(16);

    textName = itemView.findViewById(R.id.text_name);
    textMessage = itemView.findViewById(R.id.ch_textChatMessage);
    viewFileRow = itemView.findViewById(R.id.ch_viewFileRow);
    textTime = itemView.findViewById(R.id.text_time);
    textBadge = itemView.findViewById(R.id.text_badge);

    itemView.setOnClickListener(this);
    itemView.setOnLongClickListener(this);
  }

  public void bind(ChatItem chatItem) {
    this.chatItem = chatItem;

    avatar.set(chatItem.getProfile());

    textName.setText(chatItem.getProfile() != null ? chatItem.getProfile().getName() : "");

    int alert = chatItem.getAlert();
    Views.setVisibility(textBadge, alert > 0, View.INVISIBLE);
    textBadge.setText(Utils.getCount(alert, true));

    textTime.setText(TimeUtils.get(chatItem.getUpdatedAt()));

    // message

    textMessage.setVisibility(View.VISIBLE);
    viewFileRow.setVisibility(View.GONE);

    if (chatItem.isDelete()) {
      setKeyMessage("ch.message_stream.message.deleted_message", R.color.ch_grey900, 2);
    } else if (chatItem.hasReview()) {
      setKeyMessage("ch.review.complete.preview", R.color.ch_grey700, 2);
    } else if (chatItem.requestReview()) {
      setKeyMessage("ch.review.require.preview", R.color.ch_grey700, 2);
    } else if (chatItem.isClosed()) {
      setKeyMessage("ch.review.complete.title", R.color.ch_grey700, 2);
    } else if (chatItem.getFiles().size() > 0) {
      if (chatItem.getPlainText() != null) {
        setMessage(chatItem.getPlainText(), R.color.ch_grey900, 1);
      } else {
        textMessage.setVisibility(View.GONE);
      }
      viewFileRow.setVisibility(View.VISIBLE);
      viewFileRow.setFile(chatItem.getFiles().get(0), chatItem.getFiles().size());
    } else if (chatItem.getPlainText() != null) {
      setMessage(chatItem.getPlainText(), R.color.ch_grey900, 2);
    }
  }

  private void setKeyMessage(@Nullable String textKey, @ColorRes int colorId, int maxLines) {
    setMessage(ResUtils.getString(textKey), colorId, maxLines);
  }

  private void setMessage(@Nullable String text, @ColorRes int colorId, int maxLines) {
    textMessage.setText(text);
    textMessage.setTextColor(ContextCompat.getColor(itemView.getContext(), colorId));
    textMessage.setMaxLines(maxLines);
  }

  @Override
  public void onClick(View v) {
    if (listener != null && chatItem != null) {
      listener.onChatItemClick(chatItem);
    }
  }

  @Override
  public boolean onLongClick(View v) {
    if (listener != null && chatItem != null) {
      listener.onChatItemLongClick(chatItem);
    }
    return true;
  }

  public static ChatHolder newInstance(ViewGroup parent, @Nullable OnChatClickListener listener) {
    LayoutInflater inflater = LayoutInflater.from(parent.getContext());
    View itemView = inflater.inflate(R.layout.ch_plugin_item_chat, parent, false);

    return new ChatHolder(itemView, listener);
  }
}
