package com.zoyi.channel.plugin.android.activity.chat.view.viewholder;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.Block;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.layout.BorderBackgroundView;
import com.zoyi.channel.plugin.android.view.layout.message.TextMessageView;
import com.zoyi.com.annimon.stream.Optional;

import java.util.List;

public abstract class AbsMessageTextView extends LinearLayout {

  private BorderBackgroundView backHead;
  private BorderBackgroundView backContext;
  private TextMessageView textMessage;
  private TextView textDeleteMessage;

  public AbsMessageTextView(Context context) {
    super(context);
    init(context);
  }

  public AbsMessageTextView(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public AbsMessageTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  private void init(Context context) {
    View view = LayoutInflater.from(context).inflate(getLayoutId(), this, true);

    backHead = view.findViewById(R.id.ch_viewMessageHolderHeadBorder);
    backContext = view.findViewById(R.id.ch_viewMessageHolderContextBorder);
    textMessage = view.findViewById(R.id.ch_textMessageHolder);
    textDeleteMessage = view.findViewById(R.id.ch_textDeleteMessage);
  }

  public void setHead(boolean isHead) {
    Views.setVisibility(backHead, isHead);
    Views.setVisibility(backContext, !isHead);
  }

  public void setText(@Nullable CharSequence text) {
    textDeleteMessage.setVisibility(View.GONE);
    textMessage.setVisibility(View.VISIBLE);
    textMessage.setText(Optional.ofNullable(text).orElse(""));
  }

  public void setBlocks(@NonNull List<Block> blocks) {
    textDeleteMessage.setVisibility(View.GONE);
    textMessage.setVisibility(View.VISIBLE);
    textMessage.setBlocks(blocks);
  }

  public void setDelete() {
    textDeleteMessage.setVisibility(View.VISIBLE);
    textMessage.setVisibility(View.GONE);
  }

  protected void setBackColor(int backColor) {
    backHead.setColor(backColor);
    backContext.setColor(backColor);
    textMessage.setBackgroundColor(backColor);
  }

  abstract protected int getLayoutId();
}
