package com.zoyi.channel.plugin.android.activity.chat.model;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.chat.type.ContentType;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.global.Const;

public class SendTextItem extends SendItem<SendTextItem> {

  @Nullable
  private String text;

  public SendTextItem(@Nullable String chatId, @Nullable String text) {
    super(chatId);

    this.text = text;
  }

  @Nullable
  public String getText() {
    return text;
  }

  @Override
  public ContentType getContentType() {
    return ContentType.TEXT;
  }

  @Override
  public MessageType getType() {
    return MessageType.SENDING;
  }

  @Override
  public Long getPrimaryKey() {
    return createdAt * Const.SENDING_MESSAGE_PRIMARY_KEY_MULTIPLER;
  }

  @Override
  public boolean shouldShowTempMessage() {
    return true;
  }
}
