/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.media_thumbnail;

import android.content.Context;
import android.graphics.Point;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.WebPage;
import com.zoyi.channel.plugin.android.util.UriUtils;
import com.zoyi.channel.plugin.android.view.media_thumbnail.MediaThumbnailView;
import com.zoyi.channel.plugin.android.view.video_player.AbsVideoPlayerView;

public abstract class AbsPopUpMediaThumbnailView
extends MediaThumbnailView {
    private Context context;
    @Nullable
    private String messageId;
    @Nullable
    private File attachment = null;
    @Nullable
    private WebPage webPage;
    @Nullable
    private View.OnClickListener listener;

    public AbsPopUpMediaThumbnailView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public AbsPopUpMediaThumbnailView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public AbsPopUpMediaThumbnailView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
    }

    public void setAttachment(@Nullable String messageId, File attachment) {
        this.clear();
        this.webPage = null;
        this.messageId = messageId;
        this.attachment = attachment;
        if (messageId != null && attachment.getUrl() != null) {
            if (attachment.isVideo()) {
                this.onPlayClick();
            } else if (attachment.isImage()) {
                Point imageSize = this.getImageSize(attachment.getWidth().intValue(), attachment.getHeight().intValue());
                this.setImage(attachment.getThumbnailURL(imageSize), imageSize.x, imageSize.y);
            }
        }
    }

    public void setWebPage(@Nullable String messageId, WebPage webPage) {
        this.clear();
        this.attachment = null;
        this.messageId = messageId;
        this.webPage = webPage;
        this.setImage(webPage.getPreviewUrl());
        if ("YouTube".equals(webPage.getPublisher())) {
            this.activatePlayButton();
            this.onPlayClick();
        }
    }

    @Override
    public void onPlayClick() {
        if (this.messageId != null && this.listener != null) {
            if (this.webPage != null && this.webPage.getId() != null && this.webPage.getUrl() != null) {
                super.onPlayClick();
                String videoId = UriUtils.getYouTubeVideoId(this.webPage.getUrl());
                if ("YouTube".equals(this.webPage.getPublisher()) && videoId != null) {
                    this.appendVideoView(this.createYoutubePlayerView(this.context, this.messageId, this.webPage.getId(), videoId, this.listener));
                }
            }
            if (this.attachment != null) {
                super.onPlayClick();
                AbsVideoPlayerView view = this.createVideoPlayerView(this.context, this.messageId, this.attachment, this.listener);
                if (view != null) {
                    this.appendVideoView(view);
                }
            }
        }
    }

    public void setOnPushClickListener(@Nullable View.OnClickListener listener) {
        this.listener = listener;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.clear();
    }

    @Override
    public void clear() {
        super.clear();
        this.attachment = null;
        this.webPage = null;
    }

    protected abstract Point getImageSize(float var1, float var2);

    @Nullable
    protected abstract AbsVideoPlayerView createVideoPlayerView(Context var1, String var2, File var3, View.OnClickListener var4);

    protected abstract AbsVideoPlayerView createYoutubePlayerView(Context var1, String var2, String var3, String var4, View.OnClickListener var5);
}

