package com.zoyi.channel.plugin.android.model.wrapper;

import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.channel.plugin.android.store.*;

import java.util.List;

/**
 * Created by mika on 2016. 12. 8..
 */
public class UserChatWrapper extends BaseRepo {

  private UserChat userChat;
  private Session session;
  private List<Manager> managers;
  private Message message;
  private Bot bot;

  public UserChat getUserChat() {
    return userChat;
  }

  public Session getSession() {
    return session;
  }

  public Message getMessage() {
    return message;
  }

  @Override
  public void update() {
    ManagerStore.get().managers.add(managers);
    UserChatStore.get().userChats.upsert(userChat);
    UserChatStore.get().sessions.upsert(session);
    UserChatStore.get().messages.upsert(message);
    BotStore.get().bots.upsert(bot);
  }

  public void remove() {
    UserChatStore.get().userChats.remove(userChat);
    UserChatStore.get().sessions.remove(session);
    UserChatStore.get().messages.remove(message);
  }
}
