package com.zoyi.channel.plugin.android.model.source.photopicker;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by mika on 8/31/16.
 */


public class PhotoItem implements Parcelable {

  private long id;
  private String name;
  private Uri uri;
  private long size;

  public PhotoItem(long id, String name, Uri uri, long size) {
    this.id = id;
    this.name = name;
    this.uri = uri;
    this.size = size;
  }

  @Override
  public boolean equals(Object o) {
    boolean ret = false;

    if (o instanceof PhotoItem) {
      PhotoItem next = (PhotoItem) o;

      ret = this.id == next.id;
    }
    return ret;
  }

  public long getId() {
    return id;
  }

  public String getName() {
    return name;
  }

  public Uri getUri() {
    return uri;
  }

  public long getSize() {
    return size;
  }

  // parcelable

  @Override
  public int describeContents() {
    return 0;
  }

  @Override
  public void writeToParcel(Parcel parcel, int i) {
    parcel.writeLong(id);
    parcel.writeString(name);
    parcel.writeParcelable(uri, i);
    parcel.writeLong(size);
  }

  protected PhotoItem(Parcel in) {
    id = in.readLong();
    name = in.readString();
    uri = in.readParcelable(Uri.class.getClassLoader());
    size = in.readLong();
  }

  public static final Creator<PhotoItem> CREATOR = new Creator<PhotoItem>() {
    @Override
    public PhotoItem createFromParcel(Parcel in) {
      return new PhotoItem(in);
    }

    @Override
    public PhotoItem[] newArray(int size) {
      return new PhotoItem[size];
    }
  };
}
