/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.video_player;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.view.video_player.AbsVideoPlayerView;
import com.zoyi.channel.plugin.android.view.youtube.player.PlayerConstants;
import com.zoyi.channel.plugin.android.view.youtube.player.YouTubePlayer;
import com.zoyi.channel.plugin.android.view.youtube.player.listener.AbstractYouTubePlayerListener;
import com.zoyi.channel.plugin.android.view.youtube.player.views.CHYouTubePlayerView;

public abstract class AbsPopUpYouTubeVideoPlayerView
extends AbsVideoPlayerView {
    @Nullable
    private CHYouTubePlayerView playerYouTube;
    @Nullable
    protected YouTubePlayer youTubePlayer;
    private ProgressBar progressBar;
    private View viewClickCover;

    public AbsPopUpYouTubeVideoPlayerView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public AbsPopUpYouTubeVideoPlayerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public AbsPopUpYouTubeVideoPlayerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        LayoutInflater.from((Context)context).inflate(this.getLayoutId(), (ViewGroup)this);
        this.playerYouTube = (CHYouTubePlayerView)this.findViewById(R.id.chPlayerYouTube);
        this.progressBar = (ProgressBar)this.findViewById(R.id.ch_progress);
        this.viewClickCover = this.findViewById(R.id.ch_viewClickCover);
    }

    public void setVideoId(@Nullable String messageId, @Nullable String webPageId, String videoId, @Nullable View.OnClickListener listener) {
        super.setId(String.format("%s:%s:%s", messageId, webPageId, videoId));
        if (listener != null) {
            this.viewClickCover.setOnClickListener(listener);
        }
        if (this.playerYouTube != null) {
            this.playerYouTube.getPlayerUiController().showUi(false);
            this.playerYouTube.getYouTubePlayerWhenReady(youTubePlayer -> {
                this.youTubePlayer = youTubePlayer;
                youTubePlayer.mute();
                youTubePlayer.loadVideo(videoId, this.getLatestSeconds());
            });
            this.playerYouTube.addYouTubePlayerListener(new AbstractYouTubePlayerListener(){

                @Override
                public void onStateChange(YouTubePlayer youTubePlayer, PlayerConstants.PlayerState state) {
                    AbsPopUpYouTubeVideoPlayerView.this.changeVideoState(state == PlayerConstants.PlayerState.PLAYING || state == PlayerConstants.PlayerState.BUFFERING);
                }

                @Override
                public void onCurrentSecond(YouTubePlayer youTubePlayer, float second) {
                    try {
                        AbsPopUpYouTubeVideoPlayerView.this.progressBar.setProgress((int)second);
                        AbsPopUpYouTubeVideoPlayerView.this.changeVideoPosition((long)second);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                @Override
                public void onVideoDuration(YouTubePlayer youTubePlayer, float duration) {
                    AbsPopUpYouTubeVideoPlayerView.this.progressBar.setMax((int)duration);
                }
            });
        }
    }

    @Override
    void onVideoPaused() {
        if (this.youTubePlayer != null) {
            this.youTubePlayer.pause();
        }
    }

    @Override
    public void clear() {
        super.clear();
        if (this.playerYouTube != null) {
            this.playerYouTube.release();
        }
    }

    protected abstract int getLayoutId();
}

