package com.zoyi.channel.plugin.android.view.video_player;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.rx.Subscription;

public class FullScreenPopUpVideoPlayerView extends AbsPopUpVideoPlayerView {

  public FullScreenPopUpVideoPlayerView(@NonNull Context context) {
    super(context);
    init();
  }

  public FullScreenPopUpVideoPlayerView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init();
  }

  public FullScreenPopUpVideoPlayerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init();
  }

  private View buttonVideoVolumeOn;
  private View buttonVideoVolumeOff;

  @Nullable
  private Subscription hideControllerSubscription;

  @Nullable
  private OnFullScreenPopUpClickListener listener;

  private void init() {
    buttonVideoVolumeOn = findViewById(R.id.ch_buttonVideoVolumeOn);
    buttonVideoVolumeOff = findViewById(R.id.ch_buttonVideoVolumeOff);

    buttonVideoVolumeOn.setOnClickListener(v -> {
      applyVolumeButton(false);
      if (listener != null) {
        listener.onFullScreenPopUpClick();
      }
    });
    buttonVideoVolumeOff.setOnClickListener(v -> {
      applyVolumeButton(true);
      if (listener != null) {
        listener.onFullScreenPopUpClick();
      }
    });
  }

  @Override
  protected int getLayoutId() {
    return R.layout.ch_view_popup_fullscreen_video_player;
  }

  public FullScreenPopUpVideoPlayerView setUrl(@Nullable String messageId, File attachment) {
    super.setUrl(messageId, attachment);

    applyVolumeButton(false);

    return this;
  }

  public FullScreenPopUpVideoPlayerView setListener(@Nullable OnClickListener l, @Nullable OnFullScreenPopUpClickListener listener) {
    super.setOnClickListener(l);
    this.listener = listener;
    return this;
  }

  private void applyVolumeButton(boolean isVolumeOn) {
    if (exoPlayer != null) {
      exoPlayer.setVolume(isVolumeOn ? 1f : 0f);
    }

    Views.setVisibility(buttonVideoVolumeOn, isVolumeOn);
    Views.setVisibility(buttonVideoVolumeOff, !isVolumeOn);

    changeVideoVolumeState(isVolumeOn);
  }

  // clear

  @Override
  public void clear() {
    super.clear();
    dispose(hideControllerSubscription);

    hideControllerSubscription = null;
  }
}
