/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.manager;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.chat.manager.ChatManagerInterface;
import com.zoyi.channel.plugin.android.activity.chat.manager.EmptyChatManager;
import com.zoyi.channel.plugin.android.activity.chat.manager.RealChatManager;
import java.util.HashMap;

public class ChatManager {
    private static boolean initialized = false;
    private static ChatManagerInterface emptyChatManager = new EmptyChatManager();
    private static HashMap<String, ChatManagerInterface> chatManagers = new HashMap();

    public static ChatManagerInterface get(@Nullable String chatId) {
        if (initialized && chatManagers != null && chatId != null) {
            ChatManagerInterface chatManager = chatManagers.get(chatId);
            if (chatManager != null) {
                return chatManager;
            }
            RealChatManager newChatManager = new RealChatManager(chatId);
            chatManagers.put(chatId, newChatManager);
            return newChatManager;
        }
        return emptyChatManager;
    }

    public static void initialize() {
        initialized = true;
    }

    public static void release() {
        initialized = false;
        if (chatManagers != null) {
            for (ChatManagerInterface chatManager : chatManagers.values()) {
                if (chatManager == null) continue;
                chatManager.release();
            }
            chatManagers.clear();
        }
    }
}

