/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageActionListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.AbsUserMessageHolder;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.WebPage;
import com.zoyi.com.annimon.stream.Optional;

public class UserMessageHolder
extends AbsUserMessageHolder {
    @Nullable
    private OnMessageActionListener listener;
    @Nullable
    private Message message;

    private UserMessageHolder(View itemView, @Nullable OnMessageActionListener listener) {
        super(itemView, listener);
        this.listener = listener;
    }

    public void bind(ChatMessageItem item, boolean showDate, boolean isHead, boolean isTail) {
        super.bind(item.getCreatedAt(), showDate, isHead, isTail);
        this.message = item.getMessage();
        String messageId = (String)Optional.ofNullable((Object)item.getMessage()).map(Message::getId).orElse(null);
        if (item.getMessage() != null && item.getMessage().getBlocks() != null) {
            this.setBlocks(item.getMessage().getBlocks());
        }
        Optional.ofNullable((Object)item.getMessage()).map(Message::getWebPage).ifPresent(webPage -> this.setWebPage(messageId, (WebPage)webPage));
        this.setAttachments((String)Optional.ofNullable((Object)item.getMessage()).map(Message::getId).orElse(null), item.getMessage().getFiles(), this);
    }

    @Override
    public void onAttachmentClick(File attachment) {
        super.onAttachmentClick(attachment);
        if (this.listener != null && this.message != null) {
            this.listener.onAttachmentClick(attachment, this.message);
        }
    }

    public static UserMessageHolder newInstance(ViewGroup parent, @Nullable OnMessageActionListener listener) {
        return new UserMessageHolder(UserMessageHolder.getItemView(parent), listener);
    }

    @Override
    protected void clear() {
        super.clear();
        this.message = null;
    }
}

