package com.zoyi.channel.plugin.android.push;

import android.os.Bundle;
import android.text.TextUtils;

import com.zoyi.channel.plugin.android.global.Const;

class PushData {

  private static final String CHANNEL_IO = "Channel.io";

  private String message;
  private String chatId;
  private String provider;

  PushData(Bundle bundle) {
    message = bundle.getString(Const.EXTRA_MESSAGE);
    chatId = bundle.getString(Const.EXTRA_CHAT_ID);
    provider = bundle.getString(Const.EXTRA_PROVIDER);
  }

  public String getMessage() {
    return message;
  }

  public String getChatId() {
    return chatId;
  }

  public boolean isChannelPluginMessage() {
    return !TextUtils.isEmpty(provider) && provider.equals(CHANNEL_IO);
  }
}
