package com.zoyi.channel.plugin.android.action;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.model.wrapper.LoungeChatsWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.store.*;

public class LoungeAction {

  public static void fetchLounge(String pluginId, @Nullable String url) {
    setState(FetchState.LOADING);
    boolean showClosedChats = SettingsStore.get().showClosedChat.get();

    Api.getLoungeData(pluginId, url, showClosedChats)
        .runBy(ActionType.REQUEST_LOUNGE)
        .cancelBy(ActionType.SOCKET_DISCONNECTED, ActionType.SHUTDOWN)
        .run(new RestSubscriber<LoungeChatsWrapper>() {
          @Override
          public void onError(RetrofitException error) {
            setState(FetchState.FAILED);
          }

          @Override
          public void onSuccess(@NonNull LoungeChatsWrapper repo) {
            repo.set();
            setState(FetchState.COMPLETE);
          }
        });
  }

  private static void setState(FetchState fetchState) {
    SupportBotStore.get().supportBotFetchState.set(fetchState);
    UserChatStore.get().userChatsFetchState.set(fetchState);
    ChannelStore.get().channelFetchState.set(fetchState);
    PluginStore.get().pluginFetchState.set(fetchState);
  }
}
