/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.deserializer;

import android.text.TextUtils;
import com.zoyi.channel.plugin.android.model.etc.BlockParseResult;
import com.zoyi.channel.plugin.android.model.rest.ActionButton;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.util.ListUtils;
import com.zoyi.channel.plugin.android.util.lang.StringUtils;
import com.zoyi.channel.plugin.android.util.message.MessageParseOptions;
import com.zoyi.channel.plugin.android.util.message.MessageParserUtils;
import com.zoyi.com.annimon.stream.Stream;
import com.zoyi.com.google.gson.Gson;
import com.zoyi.com.google.gson.JsonDeserializationContext;
import com.zoyi.com.google.gson.JsonDeserializer;
import com.zoyi.com.google.gson.JsonElement;
import com.zoyi.com.google.gson.JsonParseException;
import java.lang.reflect.Type;

public class MessageDeserializer
implements JsonDeserializer {
    private Gson gson = new Gson();
    private MessageParseOptions options = MessageParseOptions.MessageParseOptionsBuilder.create().withEnableVariable(false).build();

    public Object deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        Message message = (Message)this.gson.fromJson(json, type);
        if (message != null) {
            if (message.getBlocks() != null && !message.getBlocks().isEmpty()) {
                BlockParseResult result = MessageParserUtils.parseBlocks(message.getBlocks(), this.options, message.getMarketing());
                message.setPlainText(result.getPlainText());
            }
            if (TextUtils.isEmpty((CharSequence)message.getPlainText()) && message.getWebPage() != null) {
                message.setPlainText(message.getWebPage().getUrl());
            }
            if (message.getAction() != null && ListUtils.hasItems(message.getAction().getButtons())) {
                for (ActionButton actionButton : message.getAction().getButtons()) {
                    actionButton.setMessage(message);
                }
                if (TextUtils.isEmpty((CharSequence)message.getPlainText())) {
                    message.setPlainText(StringUtils.join(Stream.ofNullable(message.getAction().getButtons()).map(button -> String.format("[%s]", MessageParserUtils.parseText(button.getText(), this.options).toString())).toList(), ", "));
                }
            }
        }
        return message;
    }
}

