package com.zoyi.channel.plugin.android.util;

import java.util.*;

/**
 * Created by jerry on 2018. 6. 27..
 */

public class ListUtils {

  private static <T> T checkNotNull(T reference) {
    if (reference == null) {
      throw new NullPointerException();
    }
    return reference;
  }

  public static <E> ArrayList<E> newArrayList(E... elements) {
    checkNotNull(elements);

    int capacity = computeArrayListCapacity(elements.length);

    ArrayList<E> list = new ArrayList<>(capacity);
    Collections.addAll(list, elements);
    return list;
  }

  private static int computeArrayListCapacity(int arraySize) {
    if (arraySize < 0) {
      throw new IllegalArgumentException();
    }

    long value = 5L + arraySize + (arraySize / 10);

    if (value > Integer.MAX_VALUE) {
      return Integer.MAX_VALUE;
    }
    if (value < Integer.MIN_VALUE) {
      return Integer.MIN_VALUE;
    }
    return (int) value;
  }

  public static <E> boolean hasItems(List<E> list) {
    return list != null && !list.isEmpty();
  }
}
