package com.zoyi.channel.plugin.android;

import android.support.annotation.Nullable;

import java.util.Map;

public class User {

  private String id;
  private String memberId;
  private String name;
  private String avatarUrl;
  private int alert;
  private Map<String, Object> profile;

  @Nullable
  public static User newInstance(@Nullable com.zoyi.channel.plugin.android.model.rest.User userEntity) {
    return userEntity != null ? new User(userEntity) : null;
  }

  private User(com.zoyi.channel.plugin.android.model.rest.User user) {
    this.id = user.getId();
    this.memberId = user.getMemberId();
    this.name = user.getName();
    this.avatarUrl = user.getAvatarUrl();
    this.alert = user.getAlert();
    this.profile = user.getProfile();
  }

  public String getId() {
    return id;
  }

  public String getMemberId() {
    return memberId;
  }

  public String getName() {
    return name;
  }

  public String getAvatarUrl() {
    return avatarUrl;
  }

  public int getAlert() {
    return alert;
  }

  public Map<String, Object> getProfile() {
    return profile;
  }
}
