package com.zoyi.channel.plugin.android.view.youtube.ui.utils;


import android.animation.Animator;
import android.view.View;

import com.zoyi.channel.plugin.android.view.youtube.player.PlayerConstants;
import com.zoyi.channel.plugin.android.view.youtube.player.YouTubePlayer;
import com.zoyi.channel.plugin.android.view.youtube.player.listener.YouTubePlayerListener;

public class FadeViewHelper implements YouTubePlayerListener {

  public static final long DEFAULT_ANIMATION_DURATION = 300L;
  public static final long DEFAULT_FADE_OUT_DELAY = 3000L;

  private View targetView;
  private boolean isPlaying = false;

  private boolean canFade = false;
  private boolean isVisible = true;

  private Runnable fadeOut = () -> fade(0f);

  private boolean isDisabled = false;

  /**
   * Duration of the fade animation in milliseconds.
   */
  private long animationDuration = DEFAULT_ANIMATION_DURATION;

  /**
   * Delay after which the view automatically fades out.
   */
  private long fadeOutDelay = DEFAULT_FADE_OUT_DELAY;

  public FadeViewHelper(View targetView) {
    this.targetView = targetView;
  }

  public void toggleVisibility() {
    fade(isVisible ? 0f : 1f);
  }

  private void fade(float finalAlpha) {
    if (!canFade || isDisabled) {
      return;
    }

    isVisible = finalAlpha != 0f;

    // if the controls are shown and the player is playing they should automatically fade after a while.
    // otherwise don't do anything automatically
    if (finalAlpha == 1f && isPlaying) {
      if (targetView.getHandler() != null) {
        targetView.getHandler().postDelayed(fadeOut, fadeOutDelay);
      }
    } else {
      if (targetView.getHandler() != null) {
        targetView.getHandler().removeCallbacks(fadeOut);
      }
    }

    targetView.animate()
        .alpha(finalAlpha)
        .setDuration(animationDuration)
        .setListener(new Animator.AnimatorListener() {
          @Override
          public void onAnimationStart(Animator animation) {
            if (finalAlpha == 1f) {
              targetView.setVisibility(View.VISIBLE);
            }
          }

          @Override
          public void onAnimationEnd(Animator animation) {
            if (finalAlpha == 0f) {
              targetView.setVisibility(View.GONE);
            }
          }

          @Override
          public void onAnimationCancel(Animator animation) {

          }

          @Override
          public void onAnimationRepeat(Animator animation) {

          }
        }).start();
  }

  private void updateState(PlayerConstants.PlayerState state) {
    switch (state) {
      case ENDED:
      case PAUSED:
        isPlaying = false;
        break;
      case PLAYING:
        isPlaying = true;
        break;
      case UNSTARTED:
      default:
        break;
    }
  }

  @Override
  public void onStateChange(YouTubePlayer youTubePlayer, PlayerConstants.PlayerState state) {
    updateState(state);

    switch (state) {
      case PLAYING:
      case PAUSED:
      case VIDEO_CUED:
        canFade = true;
        if (state == PlayerConstants.PlayerState.PLAYING) {
          if (targetView.getHandler() != null) {
            targetView.getHandler().postDelayed(fadeOut, fadeOutDelay);
          }
        } else {
          if (targetView.getHandler() != null) {
            targetView.getHandler().removeCallbacks(fadeOut);
          }
        }
        break;
      case BUFFERING:
      case UNSTARTED:
        fade(1f);
        canFade = false;
        break;
      case UNKNOWN:
      case ENDED:
        fade(1f);
        break;
    }
  }

  @Override
  public void onReady(YouTubePlayer youTubePlayer) {

  }

  @Override
  public void onPlaybackQualityChange(YouTubePlayer youTubePlayer, PlayerConstants.PlaybackQuality playbackQuality) {

  }

  @Override
  public void onPlaybackRateChange(YouTubePlayer youTubePlayer, PlayerConstants.PlaybackRate playbackRate) {

  }

  @Override
  public void onError(YouTubePlayer youTubePlayer, PlayerConstants.PlayerError error) {

  }

  @Override
  public void onCurrentSecond(YouTubePlayer youTubePlayer, float second) {

  }

  @Override
  public void onVideoDuration(YouTubePlayer youTubePlayer, float duration) {

  }

  @Override
  public void onVideoLoadedFraction(YouTubePlayer youTubePlayer, float loadedFraction) {

  }

  @Override
  public void onVideoId(YouTubePlayer youTubePlayer, String videoId) {

  }

  @Override
  public void onApiChange(YouTubePlayer youTubePlayer) {

  }

  public void setDisabled(boolean disabled) {
    isDisabled = disabled;
  }
}