package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;

import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageActionListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.model.rest.MessageAction;
import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.com.annimon.stream.Optional;

public class HostMessageHolder extends AbsHostMessageHolder {

  @Nullable
  private Message message;

  @Nullable
  private OnMessageActionListener listener;

  private HostMessageHolder(View itemView, @Nullable OnMessageActionListener listener) {
    super(itemView, listener);

    this.listener = listener;
  }

  public void bind(ChatMessageItem item, boolean showDate, boolean isHead, boolean isTail, boolean isLast) {
    super.bind(item.getMessage(), item.getCreatedAt(), showDate, isHead, isTail);

    this.message = item.getMessage();

    String messageId = Optional.ofNullable(item.getMessage()).map(Message::getId).orElse(null);

    Message message = item.getMessage();
    // set text
    if (message != null) {
      if (message.isDeleted()) {
        setDeleteMessage();
      } else {
        setBlockMessage(message);

        // set web page
        Optional.ofNullable(message.getWebPage()).ifPresent(webPage -> setWebPage(messageId, webPage));

        // set actions
        MessageAction action = message.getAction();

        if (isLast && action != null) {
          setActionButtons(action.getType(), action.getButtons());
        } else {
          setActionButtons(null, null);
        }

        setAttachments(message.getId(), message.getFiles(), this);
      }
    }
  }

  private void setBlockMessage(Message message) {
    if (message.getLanguage() != null
        && !message.getLanguage().equals(SettingsStore.get().locale.get().toString())
        && SettingsStore.get().showTranslation.get()
    ) {
      setTranslation(
          message.getChatId(),
          message.getId(),
          SettingsStore.get().locale.get().toString(),
          message.getBlocks()
      );
    } else {
      setBlocks(message.getBlocks());
    }
  }

  public static HostMessageHolder newInstance(ViewGroup parent, @Nullable OnMessageActionListener listener) {
    return new HostMessageHolder(getItemView(parent), listener);
  }

  @Override
  public void onAttachmentClick(File attachment) {
    super.onAttachmentClick(attachment);

    if (listener != null && message != null) {
      listener.onAttachmentClick(attachment, message);
    }
  }

  @Nullable
  @Override
  protected Marketing getMarketing() {
    return Optional.ofNullable(message).map(Message::getMarketing).orElse(null);
  }

  @Override
  protected void clear() {
    super.clear();

    this.message = null;
  }
}
