package com.zoyi.channel.plugin.android.activity.chat.contract;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.chat.model.InitMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendItem;
import com.zoyi.channel.plugin.android.contract.BaseAdapterModelContract;
import com.zoyi.channel.plugin.android.contract.BaseAdapterViewContract;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Session;

import java.util.Collection;
import java.util.List;

public interface ChatAdapterContract {

  interface View extends BaseAdapterViewContract {

  }

  interface Model extends BaseAdapterModelContract {

    void setInitMessage(InitMessageItem item);

    void setMessages(
        Collection<Message> messages,
        Collection<SendItem> unsentItems,
        @Nullable Session lastReadSession,
        @Nullable String backwardId
    );

    void addMessages(
        Collection<Message> messages,
        @Nullable Session lastReadSession,
        @Nullable String backwardId
    );

    void addMessage(Message message);

    void addMessageItem(MessageItem item);

    void addMessageItems(Collection<? extends MessageItem> items);

    void removeMessageItem(MessageItem item);

    void replaceInitMessageItem(Message message);

    void setTypings(List<Typing> typings);
  }
}
