/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.push;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.text.TextUtils;
import com.zoyi.channel.plugin.android.CHLocale;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.push.NotificationFactory;
import com.zoyi.channel.plugin.android.push.PushData;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.ImageUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.okhttp3.RequestBody;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ChannelPushManager {
    private static final int NOTIFICATION_ID = 0x3FFFFFFF;

    private static Bundle convertMessageMapToBundle(Map<String, String> message) {
        Bundle bundle = new Bundle();
        for (Map.Entry<String, String> entry : message.entrySet()) {
            bundle.putString(entry.getKey(), entry.getValue());
        }
        return bundle;
    }

    public static boolean isChannelPushNotification(Map<String, String> message) {
        return ChannelPushManager.isChannelPushNotification(ChannelPushManager.convertMessageMapToBundle(message));
    }

    public static boolean isChannelPushNotification(Bundle message) {
        if (message == null) {
            return false;
        }
        PushData pushData = new PushData(message);
        return pushData.isChannelPluginMessage();
    }

    public static void sendTokenToChannelIO(@Nullable Context context) {
        if (context != null) {
            String token = PrefSupervisor.getDeviceToken(context);
            String sentToken = PrefSupervisor.getSentDeviceToken(context);
            if (!TextUtils.isEmpty((CharSequence)token) && !CompareUtils.isSame(token, sentToken)) {
                PrefSupervisor.setSentDeviceToken(context, token);
                RequestBody body = RequestUtils.form().set("key", String.format("android-%s", ChannelPushManager.getDeviceId(context))).set("token", token).create();
                Api.getApi().sendToken(body).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(new RestSubscriber());
            }
        }
    }

    @SuppressLint(value={"HardwareIds"})
    public static void deleteToken(Context context, @Nullable String jwt) {
        if (jwt != null) {
            Api.getApi().deleteToken(((CHLocale)((Object)SettingsStore.get().locale.get())).toString(), String.format("android-%s", ChannelPushManager.getDeviceId(context)), jwt).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(new RestSubscriber());
        }
        PrefSupervisor.setSentDeviceToken(context, null);
    }

    @SuppressLint(value={"HardwareIds"})
    private static String getDeviceId(Context context) {
        String key = PrefSupervisor.getDeviceId(context);
        if (TextUtils.isEmpty((CharSequence)key)) {
            key = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            PrefSupervisor.setDeviceId(context, key);
        }
        return key;
    }

    public static void showPushNotification(Context context, Map<String, String> message) {
        ChannelPushManager.showPushNotification(context, ChannelPushManager.convertMessageMapToBundle(message));
    }

    public static void showPushNotification(Context context, Bundle message) {
        if (PrefSupervisor.hasLatestBootData(context)) {
            String channelId = message.getString("channelId");
            String personType = message.getString("personType");
            String personId = message.getString("personId");
            if (CompareUtils.equals(channelId, PrefSupervisor.getLatestBootedChannelId(context)) && CompareUtils.equals(personType, "user") && CompareUtils.equals(personId, PrefSupervisor.getLatestBootedUserId(context))) {
                ChannelPushManager.sendNotification(context, message);
                if (message.getString("chatId") != null) {
                    ChannelPushManager.receivePushNotification(message.getString("chatId"));
                }
            }
        }
    }

    private static void sendNotification(Context context, Bundle message) {
        PushData pushData = new PushData(message);
        NotificationCompat.Builder builder = NotificationFactory.createPushMessage(context, pushData);
        if (builder != null) {
            try {
                String avatarUrl = pushData.getAvatarUrl();
                if (avatarUrl == null) {
                    throw new Exception("avatar url is null");
                }
                Bitmap avatarBitmap = (Bitmap)Glide.with((Context)context).load(avatarUrl).asBitmap().into(Integer.MIN_VALUE, Integer.MIN_VALUE).get(3000L, TimeUnit.MILLISECONDS);
                if (avatarBitmap == null) {
                    throw new Exception("avatar bitmap is null");
                }
                builder.setLargeIcon(ImageUtils.getCircularBitmap(avatarBitmap));
            }
            catch (Exception ex) {
                L.e(ex.getMessage());
            }
            NotificationManagerCompat.from((Context)context).notify(0x3FFFFFFF, builder.build());
        }
    }

    private static void receivePushNotification(String chatId) {
        Api.getApi().receivePushNotification(chatId).onBackpressureBuffer().subscribeOn(Schedulers.io()).subscribe(new RestSubscriber());
    }

    static void clearNotification(Context context) {
        try {
            NotificationManagerCompat.from((Context)context).cancel(0x3FFFFFFF);
        }
        catch (Exception ex) {
            L.e(ex.getMessage());
        }
    }
}

