package com.zoyi.channel.plugin.android.store;

import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.store.base.Store;
import com.zoyi.channel.plugin.android.store.state.*;

public class UserChatStore extends Store {

  public EntityMapState<UserChat> userChats = new EntityMapState<>();

  public State<String> next = new State<>();

  public EntityMapState<Session> sessions = new EntityMapState<>(Session::getChatId);

  public EntityMapState<Message> messages = new EntityMapState<>(Message::getChatId);

  public EnumState<FetchState> userChatsFetchState = new EnumState<>(FetchState.LOADING);

  @Override
  protected void reset() {
    userChats.reset();
    sessions.reset();
    messages.reset();
    userChatsFetchState.reset();
    next.reset();
  }

  public static UserChatStore get() {
    return Store.getInstance(UserChatStore.class);
  }
}
