package com.zoyi.channel.plugin.android.view.media_thumbnail;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.widget.ImageView;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnAttachmentContentActionListener;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.util.AssetUtils;
import com.zoyi.channel.plugin.android.util.FormatUtils;
import com.zoyi.channel.plugin.android.util.io.FilenameUtils;
import com.zoyi.channel.plugin.android.view.layout.ChBorderLayout;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;

public class FileAttachmentView extends ChBorderLayout {

  public FileAttachmentView(@NonNull Context context) {
    super(context);

    init(context);
  }

  public FileAttachmentView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);

    init(context);
  }

  public FileAttachmentView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);

    init(context);
  }

  private Context context;

  private ImageView iconFileAttachment;
  private TextView textFileAttachmentName;
  private TextView textFileAttachmentInfo;

  @Nullable
  private File attachment;
  @Nullable
  private OnAttachmentContentActionListener listener;

  private void init(Context context) {
    this.context = context;

    LayoutInflater.from(context).inflate(R.layout.ch_holder_item_file_attachment, this);

    iconFileAttachment = findViewById(R.id.ch_iconFileAttachment);
    textFileAttachmentName = findViewById(R.id.ch_textFileAttachmentName);
    textFileAttachmentInfo = findViewById(R.id.ch_textFileAttachmentInfo);

    setOnClickListener(v -> {
      if (listener != null && attachment != null) {
        listener.onAttachmentClick(attachment);
      }
    });

    setOnLongClickListener(v -> {
      if (listener != null && attachment != null) {
        listener.onAttachmentLongClick(attachment);
        return true;
      }
      return false;
    });
  }

  public void setAttachment(
      File attachment,
      @Nullable OnAttachmentContentActionListener listener
  ) {
    this.attachment = attachment;
    this.listener = listener;

    Glide.with(context)
        .load(AssetUtils.getIconUrl(context, FilenameUtils.getExtension(attachment.getName())))
        .centerCrop()
        .diskCacheStrategy(DiskCacheStrategy.SOURCE)
        .into(iconFileAttachment);

    textFileAttachmentName.setText(attachment.getName());

    String contentSize = FormatUtils.formatFileSize(attachment.getSize());
    String extension = Optional.ofNullable(attachment.getExtension())
        .map(String::toLowerCase)
        .map(e -> String.format(" • %s", e))
        .orElse("");

    textFileAttachmentInfo.setText(String.format("%s%s", contentSize, extension));
  }

  public void clear() {
    Glide.clear(iconFileAttachment);
  }
}
