package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;

import com.zoyi.channel.plugin.android.activity.chat.listener.OnBaseMessageActionListener;
import com.zoyi.channel.plugin.android.activity.chat.model.SupportBotMessageItem;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.com.annimon.stream.Optional;

public class SupportBotMessageHolder extends AbsHostMessageHolder {

  private SupportBotMessageHolder(View itemView, @Nullable OnBaseMessageActionListener listener) {
    super(itemView, listener);
  }

  public void bind(SupportBotMessageItem item, boolean isLast) {
    super.bind(item.getDefaultBot(), item.getCreatedAt(), true, true, true);

    setBlocks(item.getBlocks());

    // set web page
    Optional.ofNullable(item.getWebPage()).ifPresent(webPage -> setWebPage(String.valueOf(item.getCreatedAt()), webPage));

    setAttachments(String.valueOf(item.getId()), item.getFiles(), this);

    if (item.getButtons() != null && isLast) {
      setActionButtons(Const.ACTION_TYPE_SUPPORT_BOT, item.getButtons());
    } else {
      setActionButtons(null, null);
    }
  }

  public static SupportBotMessageHolder newInstance(ViewGroup parent, @Nullable OnBaseMessageActionListener listener) {
    return new SupportBotMessageHolder(getItemView(parent), listener);
  }
}
