package com.zoyi.channel.plugin.android.action;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.Marketing;
import com.zoyi.channel.plugin.android.network.RestSubscriber;

public class MarketingAction {

  public static void sendClickEvent(@Nullable Marketing marketing) {
    if (marketing != null) {
      switch (marketing.getType()) {
        case Const.MARKETING_TYPE_CAMPAIGN:
          Api.sendCampaignClickEvent(marketing.getId()).run(new RestSubscriber<>());
          break;
        case Const.MARKETING_TYPE_ONE_TIME_MSG:
          Api.oneTimeMsgClick(marketing.getId()).run(new RestSubscriber<>());
          break;
      }
    }
  }

  public static void sendViewEvent(@Nullable Marketing marketing) {
    if (marketing != null) {
      switch (marketing.getType()) {
        case Const.MARKETING_TYPE_CAMPAIGN:
          Api.sendCampaignViewEvent(marketing.getId()).run(new RestSubscriber<>());
          break;
        case Const.MARKETING_TYPE_ONE_TIME_MSG:
          Api.oneTimeMsgView(marketing.getId()).run(new RestSubscriber<>());
          break;
      }
    }
  }
}
