/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.external.fab;

import android.support.annotation.NonNull;
import android.view.View;
import android.widget.AbsListView;

abstract class AbsListViewScrollDetector
implements AbsListView.OnScrollListener {
    private int mLastScrollY;
    private int mPreviousFirstVisibleItem;
    private AbsListView mListView;
    private int mScrollThreshold;

    AbsListViewScrollDetector() {
    }

    abstract void onScrollUp();

    abstract void onScrollDown();

    public void onScrollStateChanged(AbsListView view, int scrollState) {
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (totalItemCount == 0) {
            return;
        }
        if (this.isSameRow(firstVisibleItem)) {
            boolean isSignificantDelta;
            int newScrollY = this.getTopItemScrollY();
            boolean bl = isSignificantDelta = Math.abs(this.mLastScrollY - newScrollY) > this.mScrollThreshold;
            if (isSignificantDelta) {
                if (this.mLastScrollY > newScrollY) {
                    this.onScrollUp();
                } else {
                    this.onScrollDown();
                }
            }
            this.mLastScrollY = newScrollY;
        } else {
            if (firstVisibleItem > this.mPreviousFirstVisibleItem) {
                this.onScrollUp();
            } else {
                this.onScrollDown();
            }
            this.mLastScrollY = this.getTopItemScrollY();
            this.mPreviousFirstVisibleItem = firstVisibleItem;
        }
    }

    public void setScrollThreshold(int scrollThreshold) {
        this.mScrollThreshold = scrollThreshold;
    }

    public void setListView(@NonNull AbsListView listView) {
        this.mListView = listView;
    }

    private boolean isSameRow(int firstVisibleItem) {
        return firstVisibleItem == this.mPreviousFirstVisibleItem;
    }

    private int getTopItemScrollY() {
        if (this.mListView == null || this.mListView.getChildAt(0) == null) {
            return 0;
        }
        View topChild = this.mListView.getChildAt(0);
        return topChild.getTop();
    }
}

