package com.zoyi.channel.plugin.android.activity.lounge;

import android.Manifest;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.chat.utils.ChatUtils;
import com.zoyi.channel.plugin.android.activity.chats.ChatsActivity;
import com.zoyi.channel.plugin.android.activity.common.chat.ChatContentType;
import com.zoyi.channel.plugin.android.activity.common.error.ErrorRefreshView;
import com.zoyi.channel.plugin.android.activity.common.userchat.listener.OnChatClickListener;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.ChatItem;
import com.zoyi.channel.plugin.android.activity.common.watermark.ChannelWatermarkView;
import com.zoyi.channel.plugin.android.activity.lounge.contract.LoungeContract;
import com.zoyi.channel.plugin.android.activity.lounge.enumerate.PreviewState;
import com.zoyi.channel.plugin.android.activity.lounge.view.LoungeHeaderInteractionListener;
import com.zoyi.channel.plugin.android.activity.lounge.view.LoungeHeaderView;
import com.zoyi.channel.plugin.android.activity.lounge.view.app_messenger.LoungeIntegrationView;
import com.zoyi.channel.plugin.android.activity.lounge.view.app_messenger.OnIntegrationClickListener;
import com.zoyi.channel.plugin.android.activity.settings.SettingsActivity;
import com.zoyi.channel.plugin.android.enumerate.*;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.AppMessenger;
import com.zoyi.channel.plugin.android.selector.AppMessengerSelector;
import com.zoyi.channel.plugin.android.selector.ChatsSelector;
import com.zoyi.channel.plugin.android.store.GlobalStore;
import com.zoyi.channel.plugin.android.store.binder.Binder;
import com.zoyi.channel.plugin.android.util.*;
import com.zoyi.channel.plugin.android.util.message.MessageParserUtils;
import com.zoyi.channel.plugin.android.util.rxpermission.RxPermissions;
import com.zoyi.channel.plugin.android.view.button.ChatStartButton;
import com.zoyi.channel.plugin.android.view.coordinator.LoungeCoordinatorLayout;
import com.zoyi.channel.plugin.android.view.coordinator.PaddingNestedScrollView;
import com.zoyi.channel.plugin.android.view.dialog.ChannelDialog;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.channel.plugin.android.view.textview.EllipsizeTextView;

public class LoungeActivity
    extends
    BaseActivity2
    implements
    LoungeContract.View,
    OnChatClickListener,
    LoungeHeaderInteractionListener,
    OnIntegrationClickListener {

  private LoungeCoordinatorLayout layoutCoordinator;
  private LoungeHeaderView headerLounge;

  private View buttonCloseLounge;

  private View layoutPreviewHeader;

  // chat
  private View layoutPreviewChat;
  private RecyclerView recyclerViewChat;
  private View buttonChatStartChats;
  private ChatStartButton buttonChatStartWelcome;
  private TextView textLoungeSeeMoreChats;

  // welcome message
  private View layoutPreviewWelcome;
  private AvatarLayout avatarWelcomeMessageProfile;
  private TextView textWelcomeMessageProfile;
  private EllipsizeTextView textWelcomeMessage;

  // Apps Integrations
  private LoungeIntegrationView viewAppMessengers;

  // bottom layout
  private PaddingNestedScrollView scrollViewLounge;
  private ChannelWatermarkView watermark;

  private View layoutPreviewLoading;
  private ErrorRefreshView layoutPreviewError;

  private LoungeAdapter adapter;
  private LoungeContract.Presenter presenter;

  private LinearLayoutManager layoutManager;

  @Nullable
  private Binder appMessengersBinder;

  @Nullable
  private Binder moreChatBinder;

  private RxPermissions rxPermissions;

  @Initializer
  @Override
  protected boolean onCreate() {
    init(R.layout.ch_plugin_activity_lounge);

    setOutTransition(Transition.SLIDE_FROM_BOTTOM);

    layoutCoordinator = findViewById(R.id.layoutLoungeCoordinator);

    headerLounge = findViewById(R.id.viewLoungeHeader);
    headerLounge.setLoungeHeaderInteractionListener(this);

    buttonCloseLounge = findViewById(R.id.buttonCloseLounge);
    buttonCloseLounge.setOnClickListener(v -> Action.invoke(ActionType.EXIT));

    layoutPreviewHeader = findViewById(R.id.viewLoungePreviewHeader);

    layoutPreviewChat = findViewById(R.id.layoutLoungePreviewChat);

    layoutPreviewWelcome = findViewById(R.id.layoutLoungePreviewWelcomeMessage);
    layoutPreviewWelcome.setOnClickListener(v -> startEmptyChat());

    layoutPreviewLoading = findViewById(R.id.layoutLoungePreviewLoader);

    layoutPreviewError = findViewById(R.id.layoutLoungePreviewError);
    layoutPreviewError.setListener(v -> presenter.fetchPreviewData());

    avatarWelcomeMessageProfile = findViewById(R.id.avatarLoungePreviewWelcomeMessage);
    textWelcomeMessageProfile = findViewById(R.id.textLoungePreviewWelcomeMessageName);
    textWelcomeMessage = findViewById(R.id.textLoungePreviewWelcomeMessageMessage);

    viewAppMessengers = findViewById(R.id.ch_viewAppMessengers);
    viewAppMessengers.setListener(this);

    this.rxPermissions = new RxPermissions(this);

    appMessengersBinder = AppMessengerSelector
        .bindIntegrations((channel, plugin, appMessengers) -> viewAppMessengers.addAppMessengers(channel, plugin, appMessengers));

    layoutCoordinator.setOnNestedScrollChangeListener((scrollPosition, headerHeight) -> {
      float maxScrollPosition = Math.min(scrollPosition, headerHeight);
      float closeButtonAlpha = maxScrollPosition / headerHeight;

      headerLounge.setAlpha(1 - closeButtonAlpha);
      buttonCloseLounge.setAlpha(closeButtonAlpha);
      buttonCloseLounge.setVisibility(scrollPosition == 0 ? View.GONE : View.VISIBLE);
    });

    adapter = new LoungeAdapter();
    adapter.setListener(this);

    buttonChatStartChats = findViewById(R.id.buttonLoungePreviewChatStartChats);
    buttonChatStartChats.setOnClickListener(v -> startEmptyChat());

    layoutManager = new LinearLayoutManager(this);

    recyclerViewChat = findViewById(R.id.recyclerLoungePreviewChat);
    recyclerViewChat.setLayoutManager(layoutManager);
    recyclerViewChat.setAdapter(adapter);
    recyclerViewChat.setItemAnimator(null);
    recyclerViewChat.getRecycledViewPool().setMaxRecycledViews(0, 40);

    // bottom layout
    watermark = findViewById(R.id.watermarkLounge);

    scrollViewLounge = findViewById(R.id.scrollViewLounge);
    scrollViewLounge.setListener(isBottomScrollable -> watermark.setBorderVisibility(isBottomScrollable));

    buttonChatStartWelcome = findViewById(R.id.buttonLoungePreviewChatStartWelcome);
    buttonChatStartWelcome.setOnClickListener(v -> startEmptyChat());

    textLoungeSeeMoreChats = findViewById(R.id.textLoungeSeeMoreChats);
    textLoungeSeeMoreChats.setOnClickListener(v -> showChats());

    moreChatBinder = ChatsSelector.bindUserChatsMore(
        (hasNext, invisibleCount) -> {
          if (invisibleCount > 0) {
            textLoungeSeeMoreChats.setVisibility(View.VISIBLE);
            textLoungeSeeMoreChats.setText(
                String.format(
                    ResUtils.getString(hasNext ? "ch.lounge.show_previous_chats_more" : "ch.lounge.show_previous_chats"),
                    invisibleCount
                )
            );
          } else {
            textLoungeSeeMoreChats.setVisibility(View.GONE);
          }
        }
    );

    presenter = new LoungePresenter(this, adapter, adapter, getString(Const.EXTRA_TOP_ACTIVITY_NAME));
    bindPresenter(presenter);

    // Set states

    GlobalStore.get().messengerState.set(true);

    // handle intent

    Intent intent = getIntent();

    if (intent != null) {
      startChat(
          ChatContentType.fromString(intent.getStringExtra(Const.EXTRA_CHAT_CONTENT_TYPE)),
          intent.getStringExtra(Const.EXTRA_CHAT_CONTENT_ID),
          Transition.SLIDE_FROM_BOTTOM
      );
    }

    return true;
  }

  @Override
  protected void onNewIntent(Intent intent) {
    super.onNewIntent(intent);

    if (intent != null) {
      startChat(
          ChatContentType.fromString(intent.getStringExtra(Const.EXTRA_CHAT_CONTENT_TYPE)),
          intent.getStringExtra(Const.EXTRA_CHAT_CONTENT_ID),
          Transition.SLIDE_FROM_RIGHT
      );
    }
  }

  @Override
  protected void onPause() {
    super.onPause();

    if (isFinishing()) {
      GlobalStore.get().messengerState.set(false);

      Action.invoke(ActionType.MESSENGER_CLOSED);
    }
  }

  @Override
  protected void onDestroy() {
    super.onDestroy();

    if (appMessengersBinder != null) {
      appMessengersBinder.unbind();
      appMessengersBinder = null;
    }

    if (moreChatBinder != null) {
      moreChatBinder.unbind();
      moreChatBinder = null;
    }
  }

  // handle change

  @Override
  public void onPreviewStateChange(PreviewState previewState) {
    layoutPreviewChat.setVisibility(View.GONE);
    layoutPreviewHeader.setVisibility(View.GONE);
    layoutPreviewWelcome.setVisibility(View.GONE);
    layoutPreviewLoading.setVisibility(View.GONE);
    layoutPreviewError.setVisibility(View.GONE);
    buttonChatStartWelcome.setVisibility(View.GONE);

    switch (previewState) {
      case CHATS:
        layoutPreviewHeader.setVisibility(View.VISIBLE);
        layoutPreviewChat.setVisibility(View.VISIBLE);
        break;

      case WELCOME:
        layoutPreviewWelcome.setVisibility(View.VISIBLE);
        buttonChatStartWelcome.setVisibility(View.VISIBLE);
        break;

      case LOADING:
        layoutPreviewLoading.setVisibility(View.VISIBLE);
        break;

      case FAILED:
        layoutPreviewError.setVisibility(View.VISIBLE);
        break;
    }
  }

  @Override
  public void onDefaultProfileChange(ProfileEntity profileEntity) {
    if (profileEntity != null) {
      avatarWelcomeMessageProfile.set(profileEntity);
      textWelcomeMessageProfile.setText(profileEntity.getName());
    }
  }

  @Override
  public void onWelcomeMessageChange(String plainText) {
    if (plainText != null) {
      textWelcomeMessage.setText(plainText);
    }
  }

  @Override
  public void onChatItemClick(@NonNull ChatItem chatItem) {
    startChat(chatItem.getType(), chatItem.getSubKey(), Transition.SLIDE_FROM_RIGHT);
  }

  @Override
  public void onChatItemLongClick(@NonNull ChatItem chatItem) {
    new ChannelDialog(this)
        .setDescription(ResUtils.getString("ch.chat.delete_description"))
        .addButton(ButtonType.CANCEL)
        .addButton(ButtonType.OK, (v) -> presenter.removeChat(chatItem))
        .allowBackpress(true)
        .show();
  }

  @Override
  public void onLinkClick(String link) {
    if (ClipboardUtils.copyToClipBoard(link)) {
      Toast.makeText(this, ResUtils.getString("ch.integrations.copy_link.success"), Toast.LENGTH_SHORT).show();
    }
  }

  @Override
  public void onCallClick(String number) {
    if (number != null && this.getPackageManager().hasSystemFeature(PackageManager.FEATURE_TELEPHONY)) {
      rxPermissions.request(Manifest.permission.CALL_PHONE).subscribe(granted -> {
        if (granted) {
          Executor.call(this, number);
        } else {
          showPermissionDeniedToast();
        }
      });
    } else {
      showPermissionDeniedToast();
    }
  }

  @Override
  public void onMessengerClick(AppMessenger appMessenger) {
    presenter.fetchConnect(appMessenger);
  }

  @Override
  public void onSettingsClick() {
    IntentUtils.setNextActivity(this, SettingsActivity.class).startActivity();
  }

  @Override
  public void onExitClick() {
    Action.invoke(ActionType.EXIT);
  }

  @Override
  protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
    super.onActivityResult(requestCode, resultCode, data);

    if (requestCode == Const.REQUEST_CHAT && resultCode == Const.RESULT_CHAT_OPEN_NEW_CHAT) {
      startEmptyChat(Transition.NONE);
    }
  }

  // private methods

  private void showChats() {
    IntentUtils.setNextActivity(this, ChatsActivity.class).startActivity();
  }

  private void startEmptyChat() {
    ChatUtils.createChatActivityIntent(this).startActivityForResult(Const.REQUEST_CHAT);
  }

  private void startEmptyChat(Transition transition) {
    ChatUtils.createChatActivityIntent(this)
        .setTransition(transition)
        .startActivityForResult(Const.REQUEST_CHAT);
  }

  private void startChat(ChatContentType contentType, @Nullable String contentId, Transition transition) {
    if (contentType == ChatContentType.USER_CHAT && contentId != null) {
      ChatUtils.createChatActivityIntent(this)
          .putExtra(Const.EXTRA_CHAT_CONTENT_TYPE, contentType.toString())
          .putExtra(Const.EXTRA_CHAT_CONTENT_ID, contentId)
          .setTransition(transition)
          .startActivityForResult(Const.REQUEST_CHAT);
    }
  }

  private void showPermissionDeniedToast() {
    Toast.makeText(
        this,
        ResUtils.getString("ch.permission.denied"),
        Toast.LENGTH_LONG
    ).show();
  }
}
