/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.youtube.player.views;

import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.OnLifecycleEvent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.support.annotation.LayoutRes;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.youtube.player.PlayerConstants;
import com.zoyi.channel.plugin.android.view.youtube.player.YouTubePlayer;
import com.zoyi.channel.plugin.android.view.youtube.player.listener.AbstractYouTubePlayerListener;
import com.zoyi.channel.plugin.android.view.youtube.player.listener.YouTubePlayerCallback;
import com.zoyi.channel.plugin.android.view.youtube.player.listener.YouTubePlayerFullScreenListener;
import com.zoyi.channel.plugin.android.view.youtube.player.listener.YouTubePlayerListener;
import com.zoyi.channel.plugin.android.view.youtube.player.option.IFramePlayerOptions;
import com.zoyi.channel.plugin.android.view.youtube.player.util.FullScreenHelper;
import com.zoyi.channel.plugin.android.view.youtube.player.util.NetworkListener;
import com.zoyi.channel.plugin.android.view.youtube.player.util.PlaybackResumer;
import com.zoyi.channel.plugin.android.view.youtube.player.views.SixteenByNineFrameLayout;
import com.zoyi.channel.plugin.android.view.youtube.player.views.WebViewYouTubePlayer;
import com.zoyi.channel.plugin.android.view.youtube.ui.DefaultPlayerUiController;
import com.zoyi.channel.plugin.android.view.youtube.ui.PlayerUiController;
import com.zoyi.rx.functions.Action0;
import com.zoyi.rx.functions.Action1;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class LegacyYouTubePlayerView
extends SixteenByNineFrameLayout
implements LifecycleObserver {
    private WebViewYouTubePlayer youTubePlayer;
    private DefaultPlayerUiController defaultPlayerUiController;
    private NetworkListener networkListener = new NetworkListener();
    private PlaybackResumer playbackResumer = new PlaybackResumer();
    private FullScreenHelper fullScreenHelper = new FullScreenHelper((View)this);
    private boolean isYouTubePlayerReady = false;
    @Nullable
    private Action0 initialize;
    private Set<YouTubePlayerCallback> youTubePlayerCallbacks;
    private boolean canPlay = true;
    private boolean isUsingCustomUi = false;

    public LegacyYouTubePlayerView(Context context) {
        super(context);
        this.init(context);
    }

    public LegacyYouTubePlayerView(Context context, @Nullable AttributeSet attrs) {
        super(context, null);
        this.init(context);
    }

    public boolean isCanPlay() {
        return this.canPlay;
    }

    @Initializer
    private void init(Context context) {
        this.youTubePlayer = new WebViewYouTubePlayer(context);
        this.networkListener = new NetworkListener();
        this.playbackResumer = new PlaybackResumer();
        this.fullScreenHelper = new FullScreenHelper((View)this);
        this.youTubePlayerCallbacks = new HashSet<YouTubePlayerCallback>();
        this.addView((View)this.youTubePlayer, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.defaultPlayerUiController = new DefaultPlayerUiController(this, this.youTubePlayer);
        this.fullScreenHelper.addFullScreenListener(this.defaultPlayerUiController);
        this.youTubePlayer.addListener(this.defaultPlayerUiController);
        this.youTubePlayer.addListener(this.playbackResumer);
        this.youTubePlayer.addListener(new AbstractYouTubePlayerListener(){

            @Override
            public void onStateChange(YouTubePlayer youTubePlayer, PlayerConstants.PlayerState state) {
                if (state == PlayerConstants.PlayerState.PLAYING && !LegacyYouTubePlayerView.this.isEligibleForPlayback()) {
                    youTubePlayer.pause();
                }
            }
        });
        this.youTubePlayer.addListener(new AbstractYouTubePlayerListener(){

            @Override
            public void onReady(YouTubePlayer youTubePlayer) {
                LegacyYouTubePlayerView.this.isYouTubePlayerReady = true;
                for (YouTubePlayerCallback callback : LegacyYouTubePlayerView.this.youTubePlayerCallbacks) {
                    callback.onYouTubePlayer(youTubePlayer);
                }
                LegacyYouTubePlayerView.this.youTubePlayerCallbacks.clear();
                youTubePlayer.removeListener(this);
            }
        });
        this.networkListener.setOnNetworkAvailable(() -> {
            if (!this.isYouTubePlayerReady && this.initialize != null) {
                this.initialize.call();
            } else {
                this.playbackResumer.resume(this.youTubePlayer);
            }
        });
    }

    public WebViewYouTubePlayer getYouTubePlayer() {
        return this.youTubePlayer;
    }

    public void initialize(Context context, YouTubePlayerListener youTubePlayerListener, boolean handleNetworkEvents, @Nullable IFramePlayerOptions playerOptions) {
        if (this.isYouTubePlayerReady) {
            throw new IllegalStateException("This YouTubePlayerView has already been initialized.");
        }
        if (handleNetworkEvents) {
            context.registerReceiver((BroadcastReceiver)this.networkListener, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
        this.initialize = () -> {
            try {
                this.youTubePlayer.initialize((Action1<YouTubePlayer>)((Action1)youTubePlayer -> youTubePlayer.addListener(youTubePlayerListener)), playerOptions);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        };
        if (!handleNetworkEvents) {
            this.initialize.call();
        }
    }

    public void initialize(Context context, YouTubePlayerListener youTubePlayerListener, boolean handleNetworkEvents) {
        this.initialize(context, youTubePlayerListener, handleNetworkEvents, null);
    }

    public void initialize(Context context, YouTubePlayerListener youTubePlayerListener) {
        this.initialize(context, youTubePlayerListener, true);
    }

    public void initializeWithWebUi(Context context, YouTubePlayerListener youTubePlayerListener, boolean handleNetworkEvents) {
        IFramePlayerOptions iFramePlayerOptions = new IFramePlayerOptions.Builder().controls(1).build();
        this.inflateCustomPlayerUi(context, R.layout.ch_plugin_ayp_empty_layout);
        this.initialize(context, youTubePlayerListener, handleNetworkEvents, iFramePlayerOptions);
    }

    public void getYouTubePlayerWhenReady(YouTubePlayerCallback youTubePlayerCallback) {
        if (this.isYouTubePlayerReady) {
            youTubePlayerCallback.onYouTubePlayer(this.youTubePlayer);
        } else {
            this.youTubePlayerCallbacks.add(youTubePlayerCallback);
        }
    }

    public View inflateCustomPlayerUi(Context context, @LayoutRes int layoutId) {
        this.removeViews(1, this.getChildCount() - 1);
        if (!this.isUsingCustomUi) {
            this.youTubePlayer.removeListener(this.defaultPlayerUiController);
            this.fullScreenHelper.removeFullScreenListener(this.defaultPlayerUiController);
        }
        this.isUsingCustomUi = true;
        return View.inflate((Context)context, (int)layoutId, (ViewGroup)this);
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public void release() {
        this.removeView((View)this.youTubePlayer);
        this.youTubePlayer.removeAllViews();
        this.youTubePlayer.destroy();
        try {
            this.getContext().unregisterReceiver((BroadcastReceiver)this.networkListener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
    public void onResume() {
        this.playbackResumer.onLifecycleResume();
        this.canPlay = true;
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    public void onStop() {
        this.youTubePlayer.pause();
        this.playbackResumer.onLifecycleStop();
        this.canPlay = false;
    }

    public boolean isEligibleForPlayback() {
        return this.canPlay || this.youTubePlayer.isBackgroundPlaybackEnabled();
    }

    public void enableBackgroundPlayback(boolean enable) {
        this.youTubePlayer.setBackgroundPlaybackEnabled(enable);
    }

    public PlayerUiController getPlayerUiController() {
        if (this.isUsingCustomUi) {
            throw new RuntimeException("You have inflated a custom player Ui. You must manage it with your own controller.");
        }
        return this.defaultPlayerUiController;
    }

    public void enterFullScreen() {
        this.fullScreenHelper.enterFullScreen();
    }

    public void exitFullScreen() {
        this.fullScreenHelper.exitFullScreen();
    }

    public void toggleFullScreen() {
        this.fullScreenHelper.toggleFullScreen();
    }

    public boolean isFullScreen() {
        return this.fullScreenHelper.isFullScreen();
    }

    public boolean addFullScreenListener(YouTubePlayerFullScreenListener fullScreenListener) {
        return this.fullScreenHelper.addFullScreenListener(fullScreenListener);
    }

    public boolean removeFullScreenListener(YouTubePlayerFullScreenListener fullScreenListener) {
        return this.fullScreenHelper.removeFullScreenListener(fullScreenListener);
    }
}

