/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout.message;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatTextView;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.view.layout.message.BlockView;
import com.zoyi.channel.plugin.android.view.textview.EllipsizeTextView;
import com.zoyi.channel.plugin.android.view.textview.LinkMovementMethodOverride;

public class TextBlockView
extends FrameLayout
implements BlockView {
    private AppCompatTextView textPrefix;
    private EllipsizeTextView textMessage;
    private int textSize;
    private float textLineSpacingExtra;
    private int textColor;
    private int textLinkColor;
    private int maxLines;
    @Nullable
    private String prefix;
    private boolean isPlainText = false;

    public TextBlockView(@NonNull Context context) {
        super(context);
        View root = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_view_block_text, (ViewGroup)this);
        this.textPrefix = (AppCompatTextView)root.findViewById(R.id.ch_textBlock_prefix);
        this.textMessage = (EllipsizeTextView)root.findViewById(R.id.ch_textBlock);
        this.textMessage.setOnTouchListener(new LinkMovementMethodOverride());
    }

    public TextBlockView setPrefix(@Nullable String prefix) {
        this.prefix = prefix;
        return this;
    }

    public TextBlockView build(CharSequence charSequence) {
        if (this.prefix != null) {
            this.textPrefix.setText((CharSequence)this.prefix);
        }
        if (charSequence == null) {
            this.textMessage.setText("");
        } else {
            this.textMessage.setText(this.isPlainText ? charSequence.toString() : charSequence);
            this.textMessage.append(" ");
        }
        if (this.textSize != 0) {
            this.textPrefix.setTextSize(0, (float)this.textSize);
            this.textMessage.setTextSize(0, this.textSize);
        }
        if (this.maxLines != 0) {
            this.textMessage.setMaxLines(this.maxLines);
        }
        this.textPrefix.setLineSpacing(this.textLineSpacingExtra, 1.0f);
        this.textMessage.setLineSpacing(this.textLineSpacingExtra, 1.0f);
        if (this.textColor != 0) {
            this.textPrefix.setTextColor(this.textColor);
            this.textMessage.setTextColor(this.textColor);
        }
        if (this.textLinkColor != 0) {
            this.textMessage.setLinkTextColor(this.textLinkColor);
        }
        return this;
    }

    public TextBlockView setTextSize(int textSize) {
        this.textSize = textSize;
        return this;
    }

    public TextBlockView setLineSpacingExtra(float lineSpacingExtra) {
        this.textLineSpacingExtra = TypedValue.applyDimension((int)0, (float)lineSpacingExtra, (DisplayMetrics)this.getResources().getDisplayMetrics());
        return this;
    }

    public TextBlockView setTextColor(int textColor) {
        this.textColor = textColor;
        return this;
    }

    public TextBlockView setTextLinkColor(int textLinkColor) {
        this.textLinkColor = textLinkColor;
        return this;
    }

    public TextBlockView setPlainText(boolean isPlainText) {
        this.isPlainText = isPlainText;
        return this;
    }

    public TextBlockView setMaxLines(int maxLines) {
        this.maxLines = maxLines;
        return this;
    }

    @Override
    public void clear() {
        this.textSize = 0;
        this.textLineSpacingExtra = 0.0f;
        this.textColor = 0;
        this.maxLines = 0;
        this.prefix = null;
        this.isPlainText = false;
        this.textPrefix.setText((CharSequence)"");
        this.textMessage.setText("");
    }
}

