/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ListUtils {
    private static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static <E> ArrayList<E> newArrayList(E ... elements) {
        ListUtils.checkNotNull(elements);
        int capacity = ListUtils.computeArrayListCapacity(elements.length);
        ArrayList list = new ArrayList(capacity);
        Collections.addAll(list, elements);
        return list;
    }

    private static int computeArrayListCapacity(int arraySize) {
        if (arraySize < 0) {
            throw new IllegalArgumentException();
        }
        long value = 5L + (long)arraySize + (long)(arraySize / 10);
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (value < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)value;
    }

    public static <E> boolean hasItems(List<E> list) {
        return list != null && !list.isEmpty();
    }
}

