/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import android.app.Activity;
import android.os.Environment;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.FileUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.io.FilenameUtils;
import com.zoyi.okhttp3.Call;
import com.zoyi.okhttp3.Callback;
import com.zoyi.okhttp3.Interceptor;
import com.zoyi.okhttp3.MediaType;
import com.zoyi.okhttp3.OkHttpClient;
import com.zoyi.okhttp3.Request;
import com.zoyi.okhttp3.Response;
import com.zoyi.okhttp3.ResponseBody;
import com.zoyi.okio.Buffer;
import com.zoyi.okio.BufferedSink;
import com.zoyi.okio.BufferedSource;
import com.zoyi.okio.ForwardingSource;
import com.zoyi.okio.Okio;
import com.zoyi.okio.Sink;
import com.zoyi.okio.Source;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Locale;
import java.util.Random;

public class DownloadUtils {
    @Nullable
    private Call call;
    private static final String ALLOWED_CHARACTERS = "0123456789qwertyuiopasdfghjklzxcvbnm";

    @Nullable
    public static Call downloadFile(Activity activity, @Nullable String url, @Nullable String fileName, boolean image, ProgressListener listener) {
        String savePath;
        if (url == null || fileName == null) {
            return null;
        }
        DownloadUtils utils = new DownloadUtils();
        if (image) {
            File dir = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES), "ChannelPlugin");
            boolean created = FileUtils.createDirectory(dir);
            if (!created) {
                return null;
            }
            savePath = String.format("%s/%s", dir.getAbsolutePath(), fileName);
        } else {
            savePath = String.format("%s/%s", Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getAbsolutePath(), fileName);
        }
        return utils.download(activity, url, savePath, listener);
    }

    @Nullable
    private Call download(final Activity activity, String url, final String savePath, final ProgressListener listener) {
        String tempPath;
        try {
            tempPath = activity.getExternalCacheDir() + "/" + DownloadUtils.getRandomString(16);
        }
        catch (Exception ex) {
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    listener.error(null, "Cannot find path");
                }
            });
            return null;
        }
        Request request = new Request.Builder().url(url).build();
        OkHttpClient client = new OkHttpClient.Builder().addNetworkInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(activity, originalResponse.body(), listener)).build();
            }
        }).build();
        this.call = client.newCall(request);
        if (this.call != null) {
            this.call.enqueue(new Callback(){

                public void onFailure(final Call call, final IOException e) {
                    L.e(e.getMessage());
                    if (listener != null) {
                        activity.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                listener.error(call, e.getMessage());
                            }
                        });
                    }
                }

                public void onResponse(final Call call, Response response) throws IOException {
                    try {
                        File downloadedFile = new File(tempPath);
                        BufferedSink sink = Okio.buffer((Sink)Okio.sink((File)downloadedFile));
                        sink.writeAll((Source)response.body().source());
                        sink.close();
                        FileChannel inChannel = new FileInputStream(tempPath).getChannel();
                        for (int count = 1; count < Integer.MAX_VALUE; ++count) {
                            String newSavePath = DownloadUtils.getSavePath(savePath, count);
                            File file = new File(newSavePath);
                            if (file.exists()) continue;
                            FileChannel outChannel = new FileOutputStream(newSavePath).getChannel();
                            inChannel.transferTo(0L, inChannel.size(), outChannel);
                            inChannel.close();
                            outChannel.close();
                            FileUtils.deleteFile(new File(tempPath));
                            Executor.startFileMediaScan(activity, newSavePath);
                            activity.runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    listener.done(savePath);
                                }
                            });
                            break;
                        }
                    }
                    catch (Exception ex) {
                        response.close();
                        activity.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                listener.error(call, ex.getMessage());
                            }
                        });
                    }
                }
            });
        }
        return this.call;
    }

    private static String getSavePath(String path, int count) {
        if (count == 1) {
            return path;
        }
        String parent = FilenameUtils.getFullPathNoEndSeparator(path);
        String filename = FilenameUtils.getBaseName(path);
        String ext = FilenameUtils.getExtension(path);
        ext = !TextUtils.isEmpty((CharSequence)ext) ? String.format(".%s", ext) : "";
        return String.format(Locale.US, "%s/%s (%d)%s", parent, filename, count, ext);
    }

    private static String getRandomString(int sizeOfRandomString) {
        Random random = new Random();
        StringBuilder sb = new StringBuilder(sizeOfRandomString);
        for (int i = 0; i < sizeOfRandomString; ++i) {
            sb.append(ALLOWED_CHARACTERS.charAt(random.nextInt(ALLOWED_CHARACTERS.length())));
        }
        return sb.toString();
    }

    public static interface ProgressListener {
        public void update(int var1);

        public void error(@Nullable Call var1, @Nullable String var2);

        public void done(String var1);
    }

    private static class ProgressResponseBody
    extends ResponseBody {
        private final Activity activity;
        private final ResponseBody responseBody;
        private final ProgressListener progressListener;
        @Nullable
        private BufferedSource bufferedSource;

        ProgressResponseBody(Activity activity, ResponseBody responseBody, ProgressListener progressListener) {
            this.activity = activity;
            this.responseBody = responseBody;
            this.progressListener = progressListener;
        }

        public MediaType contentType() {
            return this.responseBody.contentType();
        }

        public long contentLength() {
            return this.responseBody.contentLength();
        }

        public BufferedSource source() {
            if (this.bufferedSource == null) {
                this.bufferedSource = Okio.buffer((Source)this.source((Source)this.responseBody.source()));
            }
            return this.bufferedSource;
        }

        private Source source(Source source) {
            return new ForwardingSource(source){
                long totalBytesRead;
                int progress;
                {
                    super(x0);
                    this.totalBytesRead = 0L;
                    this.progress = 0;
                }

                public long read(Buffer sink, long byteCount) throws IOException {
                    long bytesRead = super.read(sink, byteCount);
                    this.totalBytesRead += bytesRead != -1L ? bytesRead : 0L;
                    try {
                        final int p = (int)(100L * this.totalBytesRead / responseBody.contentLength());
                        if (p != this.progress) {
                            this.progress = p;
                            activity.runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    progressListener.update(p);
                                }
                            });
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return bytesRead;
                }
            };
        }
    }
}

