/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.profile;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.action.CountryAction;
import com.zoyi.channel.plugin.android.action.UserAction;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumber;
import com.zoyi.channel.plugin.android.activity.common.navigation.NavigationView;
import com.zoyi.channel.plugin.android.model.rest.Country;
import com.zoyi.channel.plugin.android.model.rest.ProfileBotSchema;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.selector.ProfileBotSelector;
import com.zoyi.channel.plugin.android.store.CountryStore;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.dialog.ChannelDialog;
import com.zoyi.channel.plugin.android.view.dialog.CountryCodeDialog;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;
import com.zoyi.rx.functions.Action1;
import java.util.List;
import java.util.Locale;

public class EditProfileActivity
extends BaseActivity2 {
    private NavigationView navigation;
    private View buttonSelectCountry;
    private TextView textSelectCountry;
    private WatchedEditText editText;
    private View clearText;
    @Nullable
    private String key;
    private boolean isNumeric = false;
    private int countryCode;

    @Override
    @Initializer
    protected boolean onCreate() {
        this.init(R.layout.ch_plugin_activity_edit_profile);
        this.navigation = (NavigationView)this.findViewById(R.id.navigationEditProfile);
        this.buttonSelectCountry = this.findViewById(R.id.buttonEditProfileSelectCountry);
        this.textSelectCountry = (TextView)this.findViewById(R.id.textEditProfileSelectCountry);
        this.editText = (WatchedEditText)this.findViewById(R.id.editEditProfileText);
        this.clearText = this.findViewById(R.id.buttonEditProfileClearText);
        this.key = this.getString("EXTRA_PROFILE_KEY");
        ProfileBotSchema schema = ProfileBotSelector.getProfileBotSchemaByKey(this.key);
        if (this.key == null || schema == null) {
            return false;
        }
        this.navigation.setTitle(schema.getNameI18n().get());
        this.navigation.addAction(ResUtils.getString("ch.settings.save"), v -> this.save());
        this.buttonSelectCountry.setOnClickListener(v -> this.requestCountrySelector());
        this.clearText.setOnClickListener(v -> this.editText.setText(""));
        this.editText.setWatchedTextChangedListener(s -> Views.setVisibility(this.clearText, !TextUtils.isEmpty((CharSequence)s)));
        if ("mobileNumber".equals(this.key)) {
            this.editText.setInputType(8194);
            this.initMobileNumber(this.getString("EXTRA_PROFILE_VALUE"));
        } else {
            if ("number".equals(schema.getType())) {
                this.isNumeric = true;
                this.editText.setInputType(8194);
            } else {
                this.editText.setInputType(1);
            }
            this.init(this.getString("EXTRA_PROFILE_VALUE"));
        }
        return true;
    }

    protected void onStart() {
        super.onStart();
        this.editText.requestFocus();
    }

    @Initializer
    private void init(@Nullable String value) {
        this.buttonSelectCountry.setVisibility(8);
        this.editText.setText(value);
    }

    @Initializer
    private void initMobileNumber(@Nullable String value) {
        this.buttonSelectCountry.setVisibility(0);
        MobileNumber mobileNumber = new MobileNumber(value);
        this.countryCode = mobileNumber.getCountryCode();
        this.textSelectCountry.setText((CharSequence)String.format(Locale.US, "+%d", mobileNumber.getCountryCode()));
        this.editText.setText(mobileNumber.getPhoneNumber());
    }

    private void requestCountrySelector() {
        List<Country> countries = CountryStore.get().countries.get();
        if (countries == null) {
            this.showProgress(ResUtils.getString((Context)this, "ch.loading_information"));
            CountryAction.fetchCountries(new RestSubscriber<List<Country>>(){

                @Override
                public void onError(RetrofitException error) {
                    EditProfileActivity.this.hideProgress();
                }

                @Override
                public void onSuccess(@NonNull List<Country> countries) {
                    EditProfileActivity.this.hideProgress();
                    CountryStore.get().countries.set(countries);
                    if (countries.size() > 0) {
                        EditProfileActivity.this.openCountrySelector(countries);
                    }
                }
            });
        } else {
            this.openCountrySelector(countries);
        }
    }

    private void openCountrySelector(List<Country> countries) {
        new CountryCodeDialog((Context)this, countries, (position, countryCode) -> {
            try {
                this.countryCode = Integer.valueOf(countryCode);
                this.textSelectCountry.setText((CharSequence)String.format("+%s", countryCode));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).show();
    }

    private void save() {
        String value = this.editText.getString();
        if ("mobileNumber".equals(this.key)) {
            if (TextUtils.isEmpty((CharSequence)value)) {
                this.updateProfile(null);
            } else {
                this.updateProfile(String.format(Locale.US, "+%d%s", this.countryCode, value));
            }
        } else if (TextUtils.isEmpty((CharSequence)value)) {
            this.updateProfile(null);
        } else {
            this.updateProfile(value);
        }
    }

    private void updateProfile(@Nullable String value) {
        this.showProgress();
        UserAction.updateUserProfile(this.key, value, this.isNumeric, () -> {
            this.hideProgress();
            this.finish();
        }, (Action1<String>)((Action1)message -> {
            this.hideProgress();
            if (message != null) {
                new ChannelDialog((Context)this).setDescription((String)message).show();
            }
        }));
    }
}

