/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.zoyi.channel.plugin.android.ChannelApiManager;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelPluginCompletionStatus;
import com.zoyi.channel.plugin.android.ChannelPluginSettings;
import com.zoyi.channel.plugin.android.OnBootListener;
import com.zoyi.channel.plugin.android.Profile;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.wrapper.PackageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.store2.GlobalStore;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.DeviceUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.okhttp3.RequestBody;
import com.zoyi.rx.Observable;
import java.util.HashMap;
import java.util.Map;

public class BootManager {
    public static Observable<PluginWrapper> bootPlugin(ChannelPluginSettings pluginSettings, Profile profile) {
        return ChannelApiManager.get().bootV2(BootManager.createBootHeader(), BootManager.createBootBody(pluginSettings, profile), pluginSettings.getPluginKey());
    }

    private static Map<String, String> createBootHeader() {
        HashMap<String, String> headers = new HashMap<String, String>();
        String veilId = PrefSupervisor.getVeilId(ChannelIO.getAppContext());
        if (veilId != null && !TextUtils.isEmpty((CharSequence)veilId)) {
            headers.put("X-Veil-Id", veilId.substring(0, 16));
        }
        return headers;
    }

    private static RequestBody createBootBody(ChannelPluginSettings pluginSettings, @Nullable Profile profile) {
        String wId;
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        if (pluginSettings.getUserId() != null) {
            bodyMap.put("userId", pluginSettings.getUserId());
        }
        if (profile != null) {
            HashMap<String, Object> profileMap = new HashMap<String, Object>();
            profileMap.put("name", profile.getName());
            profileMap.put("avatarUrl", profile.getAvatarUrl());
            profileMap.put("mobileNumber", profile.getMobileNumber());
            profileMap.put("email", profile.getEmail());
            for (Map.Entry<String, Object> entry : profile.getProperty().entrySet()) {
                profileMap.put(entry.getKey(), entry.getValue());
            }
            bodyMap.put("profile", profileMap);
        }
        HashMap<String, String> sysProfileMap = new HashMap<String, String>();
        sysProfileMap.put("platform", "android");
        sysProfileMap.put("version", "6.1.9-beta1");
        String adId = GlobalStore.get().adId.get();
        if (adId != null) {
            sysProfileMap.put("adId", adId);
        }
        if ((wId = DeviceUtils.getWId(ChannelIO.getAppContext())) != null) {
            sysProfileMap.put("$wId", wId);
        }
        bodyMap.put("sysProfile", sysProfileMap);
        return RequestUtils.form(bodyMap).create();
    }

    public static boolean isValidVersion(PackageWrapper packageWrapper, OnBootListener onBootListener) {
        if (packageWrapper == null) {
            if (onBootListener != null) {
                onBootListener.onCompletion(ChannelPluginCompletionStatus.NETWORK_TIMEOUT, null);
            }
            return false;
        }
        if (packageWrapper.isNeedToUpgrade()) {
            if (onBootListener != null) {
                onBootListener.onCompletion(ChannelPluginCompletionStatus.NOT_AVAILABLE_VERSION, null);
            }
            return false;
        }
        if (!CompareUtils.isSame(packageWrapper.getVersionString(), "6.1.9-beta1")) {
            L.i("Newest version is: " + packageWrapper.getVersionString());
        }
        return true;
    }

    public static boolean isValidPlugin(PluginWrapper pluginWrapper, OnBootListener onBootListener) {
        if (pluginWrapper == null || !pluginWrapper.isValid()) {
            if (onBootListener != null) {
                onBootListener.onCompletion(ChannelPluginCompletionStatus.NETWORK_TIMEOUT, null);
            }
            return false;
        }
        if (!pluginWrapper.canUseMobileSDK()) {
            if (onBootListener != null) {
                onBootListener.onCompletion(ChannelPluginCompletionStatus.REQUIRE_PAYMENT, null);
            }
            return false;
        }
        return true;
    }

    public static void sendNetworkError(OnBootListener onBootListener, RetrofitException exception) {
        if (onBootListener != null) {
            String errorMessage = "Unknown error";
            if (exception != null) {
                errorMessage = exception.getMessage();
                ChannelPluginCompletionStatus status = exception.is4xxClientError() ? ChannelPluginCompletionStatus.ACCESS_DENIED : (exception.is5xxServerError() ? ChannelPluginCompletionStatus.SERVICE_UNDER_CONSTRUCTION : (exception.isConnectionTimeOutError() ? ChannelPluginCompletionStatus.NETWORK_TIMEOUT : (exception.isHttpError() ? ChannelPluginCompletionStatus.NOT_INITIALIZED : ChannelPluginCompletionStatus.UNKNOWN_ERROR)));
                onBootListener.onCompletion(status, null);
            } else {
                onBootListener.onCompletion(ChannelPluginCompletionStatus.UNKNOWN_ERROR, null);
            }
            L.e(errorMessage);
        }
    }
}

