/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chats;

import com.zoyi.channel.plugin.android.action.ChatAction;
import com.zoyi.channel.plugin.android.activity.chats.contract.ChatsAdapterContract;
import com.zoyi.channel.plugin.android.activity.chats.contract.ChatsContract;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.ChatItem;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.PushBotChatItem;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.UserChatItem;
import com.zoyi.channel.plugin.android.base.AbstractAdapterPresenter;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.selector2.ChatsSelector;
import com.zoyi.channel.plugin.android.store2.PushBotStore;
import com.zoyi.channel.plugin.android.store2.UserChatStore;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.functions.Action2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ChatsPresenter
extends AbstractAdapterPresenter<ChatsContract.View, ChatsAdapterContract.View, ChatsAdapterContract.Model>
implements ChatsContract.Presenter {
    public ChatsPresenter(ChatsContract.View view, ChatsAdapterContract.View adapterView, ChatsAdapterContract.Model adapterModel) {
        super(view, adapterView, adapterModel);
    }

    @Override
    public void init() {
        this.bind(ChatsSelector.bindChats((Action2<List<ChatItem>, List<ChatItem>>)((Action2)(activeChatItems, closedChatItems) -> {
            boolean isOnTop = ((ChatsContract.View)this.view).isOnTop();
            ArrayList<ChatItem> chatItems = new ArrayList<ChatItem>();
            chatItems.addAll((Collection<ChatItem>)activeChatItems);
            chatItems.addAll((Collection<ChatItem>)closedChatItems);
            ((ChatsAdapterContract.Model)this.adapterModel).updateChatItems(chatItems);
            ((ChatsContract.View)this.view).onChatsCountChange(chatItems.size());
            if (isOnTop) {
                ((ChatsContract.View)this.view).scrollToTop();
            }
        })));
        this.bind(ChatsSelector.bindUserChatsFetchState((Action1<FetchState>)((Action1)fetchState -> ((ChatsContract.View)this.view).onUserChatsFetchStateChange((FetchState)((Object)fetchState)))));
    }

    @Override
    public void removeChat(ChatItem item) {
        PushBotItem pushBotItem;
        if (item instanceof PushBotChatItem && (pushBotItem = (PushBotItem)PushBotStore.get().pushBots.get(item.getId())) != null) {
            pushBotItem.remove();
            PushBotStore.get().pushBots.upsert(pushBotItem);
        }
        if (item instanceof UserChatItem) {
            ((ChatsContract.View)this.view).showProgress(ResUtils.getString("ch.chat.delete_progress"));
            ChatAction.removeUserChat(item.getId(), () -> {
                ((ChatsContract.View)this.view).hideProgress();
                UserChatStore.get().userChats.removeByKey(item.getId());
            }, () -> ((ChatsContract.View)this.view).hideProgress());
        }
    }
}

