/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat3;

import android.app.Activity;
import android.graphics.Rect;
import android.os.Build;
import android.support.v7.widget.RecyclerView;
import android.view.DisplayCutout;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowInsets;
import android.view.inputmethod.InputMethodManager;
import com.zoyi.channel.plugin.android.activity.chat3.ChatActivity;

public class KeyboardUtils {
    private ChatActivity chatActivity;
    private View decorView;
    private View contentView;
    private RecyclerView recyclerView;
    private ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            Rect r = new Rect();
            KeyboardUtils.this.decorView.getWindowVisibleDisplayFrame(r);
            Rect cutout = KeyboardUtils.this.getDisplayCutout();
            Rect systemInsets = KeyboardUtils.this.getSystemWindowInsets();
            Rect stableInsets = KeyboardUtils.this.getStableInsets();
            int viewHeight = ((KeyboardUtils)KeyboardUtils.this).decorView.getContext().getResources().getDisplayMetrics().heightPixels;
            int windowHeight = r.bottom - r.top;
            int diff = viewHeight - stableInsets.top + cutout.top - windowHeight;
            if (diff != 0) {
                if (KeyboardUtils.this.contentView.getPaddingBottom() != diff) {
                    boolean isOnBottom = !KeyboardUtils.this.recyclerView.canScrollVertically(1);
                    KeyboardUtils.this.contentView.setPadding(0, 0, 0, diff);
                    if (isOnBottom) {
                        KeyboardUtils.this.chatActivity.scrollToBottom();
                    }
                }
            } else if (KeyboardUtils.this.contentView.getPaddingBottom() != 0) {
                KeyboardUtils.this.contentView.setPadding(0, 0, 0, 0);
            }
        }
    };

    public KeyboardUtils(ChatActivity activity, View contentView, RecyclerView recyclerView) {
        this.chatActivity = activity;
        this.decorView = activity.getWindow().getDecorView();
        this.contentView = contentView;
        this.recyclerView = recyclerView;
        if (Build.VERSION.SDK_INT >= 19) {
            this.decorView.getViewTreeObserver().addOnGlobalLayoutListener(this.onGlobalLayoutListener);
        }
    }

    public void enable() {
        if (Build.VERSION.SDK_INT >= 19) {
            this.decorView.getViewTreeObserver().addOnGlobalLayoutListener(this.onGlobalLayoutListener);
        }
    }

    public void disable() {
        if (Build.VERSION.SDK_INT >= 19) {
            this.decorView.getViewTreeObserver().removeOnGlobalLayoutListener(this.onGlobalLayoutListener);
        }
    }

    private Rect getDisplayCutout() {
        if (Build.VERSION.SDK_INT >= 28 && this.decorView != null && this.decorView.getRootWindowInsets() != null && this.decorView.getRootWindowInsets().getDisplayCutout() != null) {
            DisplayCutout displayCutout = this.decorView.getRootWindowInsets().getDisplayCutout();
            return new Rect(displayCutout.getSafeInsetLeft(), displayCutout.getSafeInsetTop(), displayCutout.getSafeInsetRight(), displayCutout.getSafeInsetBottom());
        }
        return new Rect(0, 0, 0, 0);
    }

    private Rect getSystemWindowInsets() {
        if (Build.VERSION.SDK_INT >= 23 && this.decorView != null && this.decorView.getRootWindowInsets() != null) {
            WindowInsets rootWindowInsets = this.decorView.getRootWindowInsets();
            return new Rect(rootWindowInsets.getSystemWindowInsetLeft(), rootWindowInsets.getSystemWindowInsetTop(), rootWindowInsets.getSystemWindowInsetRight(), rootWindowInsets.getSystemWindowInsetBottom());
        }
        return new Rect(0, 0, 0, 0);
    }

    private Rect getStableInsets() {
        if (Build.VERSION.SDK_INT >= 23 && this.decorView != null && this.decorView.getRootWindowInsets() != null) {
            WindowInsets rootWindowInsets = this.decorView.getRootWindowInsets();
            return new Rect(rootWindowInsets.getStableInsetLeft(), rootWindowInsets.getStableInsetTop(), rootWindowInsets.getStableInsetRight(), rootWindowInsets.getStableInsetBottom());
        }
        return new Rect(0, 0, 0, 0);
    }

    public static void hideKeyboard(Activity activity) {
        if (activity != null && activity.getCurrentFocus() != null) {
            InputMethodManager inputMethodManager = (InputMethodManager)activity.getSystemService("input_method");
            inputMethodManager.hideSoftInputFromWindow(activity.getCurrentFocus().getWindowToken(), 0);
        }
    }
}

