package com.zoyi.channel.plugin.android.util;

import android.support.annotation.Nullable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import com.zoyi.channel.plugin.android.deserializer.MessageDeserializer;
import com.zoyi.channel.plugin.android.deserializer.TranslationRepoDeserializer;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.wrapper.TranslationRepo;
import com.zoyi.channel.plugin.android.util.message_format.MessageParser;
import com.zoyi.com.google.gson.Gson;
import com.zoyi.com.google.gson.GsonBuilder;

/**
 * Created by jerry on 2018. 3. 27..
 */

public class ParseUtils {

  @Nullable
  private static Gson gson;

  public static Gson getCustomGson() {
    if (gson == null) {
      GsonBuilder builder = new GsonBuilder();
      builder.registerTypeAdapter(Message.class, new MessageDeserializer());
      builder.registerTypeAdapter(TranslationRepo.class, new TranslationRepoDeserializer());

      gson = builder.create();
    }

    return gson;
  }

  @Nullable
  public static SpannableStringBuilder parseMessage(String title, String message) {
    MessageParser parser = MessageParser.get();

    if(title != null){
      message = String.format("**%s** %s", title, message);
    }

    if (TextUtils.isEmpty(message) || parser == null) {
      return new SpannableStringBuilder("");
    }
    return parser.parse(message);
  }

  @Nullable
  public static SpannableStringBuilder parseMessage(String message) {
    MessageParser parser = MessageParser.get();

    if (TextUtils.isEmpty(message) || parser == null) {
      return new SpannableStringBuilder("");
    }
    return parser.parse(message);
  }

  @Nullable
  public static<T> T parseJson(String entity, Class<T> target) {
    try {
      return getCustomGson().fromJson(entity, target);
    } catch (Exception ex) {
      L.e(ex.getMessage());
    }
    return null;
  }
}
